/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.IStringArray;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEntryList<T extends IForgeRegistryEntry<T>>
implements IStringArray {
    private final IForgeRegistry<T> REGISTRY;
    protected final Set<T> UNDERLYING_SET = new HashSet<T>();
    protected final List<String> PRINT_LIST = new ArrayList<String>();

    protected RegistryEntryList(IForgeRegistry<T> registry) {
        this.REGISTRY = registry;
    }

    @SafeVarargs
    public RegistryEntryList(IForgeRegistry<T> registry, T ... entries) {
        this(registry);
        for (T entry : entries) {
            if (!this.UNDERLYING_SET.add(entry)) continue;
            this.PRINT_LIST.add(SpecialMobs.toString(registry.getKey(entry)));
        }
    }

    public RegistryEntryList(AbstractConfigField field, IForgeRegistry<T> registry, List<String> entries) {
        this(registry);
        for (String line : entries) {
            if (line.endsWith("*")) {
                if (!this.mergeFromNamespace(line.substring(0, line.length() - 1))) {
                    SpecialMobs.LOG.warn("Namespace entry for {} \"{}\" did not match anything! Questionable entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                }
                this.PRINT_LIST.add(line);
                continue;
            }
            ResourceLocation regKey = new ResourceLocation(line);
            if (this.mergeFrom(regKey)) {
                this.PRINT_LIST.add(regKey.toString());
                continue;
            }
            SpecialMobs.LOG.warn("Invalid or duplicate entry for {} \"{}\"! Deleting entry. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
        }
    }

    public IForgeRegistry<T> getRegistry() {
        return this.REGISTRY;
    }

    public Set<T> getEntries() {
        return Collections.unmodifiableSet(this.UNDERLYING_SET);
    }

    public String toString() {
        return TomlHelper.toLiteral(this.PRINT_LIST.toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RegistryEntryList)) {
            return false;
        }
        return this.getRegistry() == ((RegistryEntryList)other).getRegistry() && this.toStringList().equals(((RegistryEntryList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        return this.PRINT_LIST;
    }

    public boolean isEmpty() {
        return this.UNDERLYING_SET.isEmpty();
    }

    public boolean contains(@Nullable T entry) {
        return this.UNDERLYING_SET.contains(entry);
    }

    protected boolean mergeFrom(ResourceLocation regKey) {
        IForgeRegistryEntry entry = this.REGISTRY.getValue(regKey);
        return entry != null && this.UNDERLYING_SET.add(entry);
    }

    protected boolean mergeFromNamespace(String namespace) {
        boolean foundAny = false;
        for (ResourceLocation regKey : this.REGISTRY.getKeys()) {
            if (!regKey.toString().startsWith(namespace) || !this.mergeFrom(regKey)) continue;
            foundAny = true;
        }
        return foundAny;
    }
}

