/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.util.RegistryEntryList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LazyRegistryEntryList<T extends IForgeRegistryEntry<T>>
extends RegistryEntryList<T> {
    private final AbstractConfigField FIELD;
    private boolean populated;

    @SafeVarargs
    public LazyRegistryEntryList(IForgeRegistry<T> registry, T ... entries) {
        super(registry, entries);
        this.FIELD = null;
        this.populated = true;
    }

    public LazyRegistryEntryList(IForgeRegistry<T> registry, Object ... entries) {
        super(registry);
        this.FIELD = null;
        for (Object entry : entries) {
            if (entry instanceof IForgeRegistryEntry) {
                ResourceLocation regKey = ((IForgeRegistryEntry)entry).getRegistryName();
                if (regKey == null) {
                    throw new IllegalArgumentException("Invalid default lazy registry list entry! " + entry);
                }
                this.PRINT_LIST.add(regKey.toString());
                continue;
            }
            if (entry instanceof RegistryObject) {
                this.PRINT_LIST.add(((RegistryObject)entry).getId().toString());
                continue;
            }
            if (entry instanceof ResourceLocation) {
                this.PRINT_LIST.add(entry.toString());
                continue;
            }
            if (entry instanceof String) {
                this.PRINT_LIST.add((String)entry);
                continue;
            }
            throw new IllegalArgumentException("Invalid default lazy registry list entry! " + entry);
        }
    }

    public LazyRegistryEntryList(AbstractConfigField field, IForgeRegistry<T> registry, List<String> entries) {
        super(registry);
        this.FIELD = field;
        for (String line : entries) {
            if (line.endsWith("*")) {
                this.PRINT_LIST.add(line);
                continue;
            }
            this.PRINT_LIST.add(new ResourceLocation(line).toString());
        }
    }

    private void populateEntries() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        for (String line : this.PRINT_LIST) {
            if (line.endsWith("*")) {
                if (this.mergeFromNamespace(line.substring(0, line.length() - 1))) continue;
                SpecialMobs.LOG.warn("Namespace entry for {} \"{}\" did not match anything! Questionable entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)line);
                continue;
            }
            ResourceLocation regKey = new ResourceLocation(line);
            if (this.mergeFrom(regKey)) continue;
            SpecialMobs.LOG.warn("Invalid or duplicate entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)line);
        }
    }

    @Override
    public Set<T> getEntries() {
        this.populateEntries();
        return super.getEntries();
    }

    @Override
    public boolean isEmpty() {
        return this.populated ? super.isEmpty() : this.PRINT_LIST.isEmpty();
    }

    @Override
    public boolean contains(@Nullable T entry) {
        this.populateEntries();
        return super.contains(entry);
    }
}

