/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.IStringArray;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnvironmentList
implements IStringArray {
    private final EnvironmentEntry[] ENTRIES;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public EnvironmentList(List<EnvironmentEntry> entries) {
        this(entries.toArray(new EnvironmentEntry[0]));
    }

    public EnvironmentList(EnvironmentEntry ... entries) {
        this.ENTRIES = entries;
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EnvironmentList)) {
            return false;
        }
        return this.toStringList().equals(((EnvironmentList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (EnvironmentEntry entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        return list;
    }

    public double getOrElse(World world, @Nullable BlockPos pos, DoubleField defaultValue) {
        return this.getOrElse(world, pos, defaultValue.get());
    }

    public double getOrElse(World world, @Nullable BlockPos pos, double defaultValue) {
        Double value = this.get(world, pos);
        return value == null ? defaultValue : value;
    }

    @Nullable
    public Double get(World world, @Nullable BlockPos pos) {
        for (EnvironmentEntry entry : this.ENTRIES) {
            if (!entry.matches(world, pos)) continue;
            return entry.VALUE;
        }
        return null;
    }

    public EnvironmentList setRange(DoubleField.Range range) {
        return this.setRange(range.MIN, range.MAX);
    }

    public EnvironmentList setRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

