/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.config.util.environment.ComparisonOperator;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategoryEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.RainfallEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TemperatureEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TerrainDepthEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TerrainScaleEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionPropertyEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionTypeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionTypeGroupEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.PositionEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.StructureEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.YEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.YFromSeaEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.ChunkTimeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.DayTimeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.MoonBrightnessEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.MoonPhaseEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.SpecialDifficultyEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.TimeFromMidnightEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.WeatherEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.WorldTimeEnvironment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.structure.Structure;

public class EnvironmentEntry {
    public final double VALUE;
    private final AbstractEnvironment[] CONDITIONS;

    public EnvironmentEntry(double value, List<AbstractEnvironment> conditions) {
        this(value, conditions.toArray(new AbstractEnvironment[0]));
    }

    public EnvironmentEntry(double value, AbstractEnvironment ... conditions) {
        this.VALUE = value;
        this.CONDITIONS = conditions;
    }

    public boolean matches(World world, @Nullable BlockPos pos) {
        for (AbstractEnvironment condition : this.CONDITIONS) {
            if (condition.matches(world, pos)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder().append(this.VALUE).append(' ');
        boolean first = true;
        for (AbstractEnvironment condition : this.CONDITIONS) {
            if (first) {
                first = false;
            } else {
                str.append(" & ");
            }
            str.append(condition);
        }
        return str.toString();
    }

    public static Builder builder(float value) {
        return new Builder((double)Math.round((double)value * 100.0) / 100.0);
    }

    public static Builder builder(double value) {
        return new Builder(value);
    }

    public static class Builder {
        private final double VALUE;
        private final ArrayList<AbstractEnvironment> CONDITIONS = new ArrayList();

        private Builder(double value) {
            this.VALUE = value;
        }

        public EnvironmentEntry build() {
            return new EnvironmentEntry(this.VALUE, this.CONDITIONS);
        }

        public Builder in(AbstractEnvironment condition) {
            this.CONDITIONS.add(condition);
            return this;
        }

        public Builder inUltraWarmDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.ULTRAWARM, false);
        }

        public Builder notInUltraWarmDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.ULTRAWARM, true);
        }

        public Builder inNaturalDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.NATURAL, false);
        }

        public Builder notInNaturalDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.NATURAL, true);
        }

        private Builder inDimensionWithProperty(DimensionPropertyEnvironment.Value property, boolean invert) {
            return this.in(new DimensionPropertyEnvironment(property, invert));
        }

        public Builder inOverworld() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_235999_c_, false);
        }

        public Builder notInOverworld() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_235999_c_, true);
        }

        public Builder inNether() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_236000_d_, false);
        }

        public Builder notInNether() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_236000_d_, true);
        }

        public Builder inTheEnd() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_236001_e_, false);
        }

        public Builder notInTheEnd() {
            return this.inDimensionType((RegistryKey<DimensionType>)DimensionType.field_236001_e_, true);
        }

        private Builder inDimensionType(RegistryKey<DimensionType> dimType, boolean invert) {
            return this.in(new DimensionTypeEnvironment(dimType, invert));
        }

        public Builder inVanillaDimension() {
            return this.in(new DimensionTypeGroupEnvironment(new ResourceLocation(""), false));
        }

        public Builder notInVanillaDimension() {
            return this.in(new DimensionTypeGroupEnvironment(new ResourceLocation(""), true));
        }

        public Builder inWaterBiome() {
            return this.isDepth(ComparisonOperator.LESS_OR_EQUAL, 0.0f);
        }

        public Builder notInWaterBiome() {
            return this.isDepth(ComparisonOperator.LESS_OR_EQUAL.invert(), 0.0f);
        }

        public Builder inMountainBiome() {
            return this.isDepth(ComparisonOperator.GREATER_OR_EQUAL, 0.4f);
        }

        public Builder notInMountainBiome() {
            return this.isDepth(ComparisonOperator.GREATER_OR_EQUAL.invert(), 0.4f);
        }

        private Builder isDepth(ComparisonOperator op, float value) {
            return this.in(new TerrainDepthEnvironment(op, value));
        }

        public Builder inFlatBiome() {
            return this.isScale(ComparisonOperator.LESS_OR_EQUAL, 0.1f);
        }

        public Builder notInFlatBiome() {
            return this.isScale(ComparisonOperator.LESS_OR_EQUAL.invert(), 0.1f);
        }

        public Builder inHillyBiome() {
            return this.isScale(ComparisonOperator.GREATER_OR_EQUAL, 0.3f);
        }

        public Builder notInHillyBiome() {
            return this.isScale(ComparisonOperator.GREATER_OR_EQUAL.invert(), 0.3f);
        }

        private Builder isScale(ComparisonOperator op, float value) {
            return this.in(new TerrainScaleEnvironment(op, value));
        }

        public Builder inDryBiome() {
            return this.inAvgRainfall(ComparisonOperator.EQUAL_TO, 0.0f);
        }

        public Builder notInDryBiome() {
            return this.inAvgRainfall(ComparisonOperator.EQUAL_TO.invert(), 0.0f);
        }

        public Builder inHumidBiome() {
            return this.inAvgRainfall(ComparisonOperator.GREATER_THAN, 0.85f);
        }

        public Builder notInHumidBiome() {
            return this.inAvgRainfall(ComparisonOperator.GREATER_THAN.invert(), 0.85f);
        }

        private Builder inAvgRainfall(ComparisonOperator op, float value) {
            return this.in(new RainfallEnvironment(op, value));
        }

        public Builder isFreezing() {
            return this.in(new TemperatureEnvironment(true));
        }

        public Builder isNotFreezing() {
            return this.in(new TemperatureEnvironment(false));
        }

        public Builder isWarm() {
            return this.isTemperature(ComparisonOperator.GREATER_OR_EQUAL, 0.8f);
        }

        public Builder isNotWarm() {
            return this.isTemperature(ComparisonOperator.GREATER_OR_EQUAL.invert(), 0.8f);
        }

        public Builder isHot() {
            return this.isTemperature(ComparisonOperator.GREATER_THAN, 1.0f);
        }

        public Builder isNotHot() {
            return this.isTemperature(ComparisonOperator.GREATER_THAN.invert(), 1.0f);
        }

        private Builder isTemperature(ComparisonOperator op, float value) {
            return this.in(new TemperatureEnvironment(op, value));
        }

        public Builder inBiomeCategory(BiomeCategory category) {
            return this.in(new BiomeCategoryEnvironment(category, false));
        }

        public Builder notInBiomeCategory(BiomeCategory category) {
            return this.in(new BiomeCategoryEnvironment(category, true));
        }

        public Builder inBiome(RegistryKey<Biome> biome) {
            return this.in(new BiomeEnvironment(biome, false));
        }

        public Builder notInBiome(RegistryKey<Biome> biome) {
            return this.in(new BiomeEnvironment(biome, true));
        }

        public Builder inStructure(Structure<?> structure) {
            return this.in(new StructureEnvironment(structure, false));
        }

        public Builder notInStructure(Structure<?> structure) {
            return this.in(new StructureEnvironment(structure, true));
        }

        public Builder belowDiamondLevel() {
            return this.belowY(15);
        }

        public Builder aboveDiamondLevel() {
            return this.aboveY(15);
        }

        public Builder belowGoldLevel() {
            return this.belowY(33);
        }

        public Builder aboveGoldLevel() {
            return this.aboveY(33);
        }

        private Builder belowY(int y) {
            return this.in(new YEnvironment(ComparisonOperator.LESS_OR_EQUAL, y));
        }

        private Builder aboveY(int y) {
            return this.in(new YEnvironment(ComparisonOperator.LESS_OR_EQUAL.invert(), y));
        }

        public Builder belowSeaLevel() {
            return this.belowSeaLevel(0);
        }

        public Builder aboveSeaLevel() {
            return this.aboveSeaLevel(0);
        }

        public Builder belowSeaDepths() {
            return this.belowSeaLevel(-6);
        }

        public Builder aboveSeaDepths() {
            return this.aboveSeaLevel(-6);
        }

        public Builder belowSeaFloor() {
            return this.belowSeaLevel(-18);
        }

        public Builder aboveSeaFloor() {
            return this.aboveSeaLevel(-18);
        }

        public Builder belowMountainLevel() {
            return this.belowSeaLevel(25);
        }

        public Builder aboveMountainLevel() {
            return this.aboveSeaLevel(25);
        }

        private Builder belowSeaLevel(int dY) {
            return this.in(new YFromSeaEnvironment(ComparisonOperator.LESS_OR_EQUAL, dY));
        }

        private Builder aboveSeaLevel(int dY) {
            return this.in(new YFromSeaEnvironment(ComparisonOperator.LESS_OR_EQUAL.invert(), dY));
        }

        public Builder canSeeSky() {
            return this.inPositionWithState(PositionEnvironment.Value.CAN_SEE_SKY, false);
        }

        public Builder cannotSeeSky() {
            return this.inPositionWithState(PositionEnvironment.Value.CAN_SEE_SKY, true);
        }

        public Builder isNearVillage() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_VILLAGE, false);
        }

        public Builder isNotNearVillage() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_VILLAGE, true);
        }

        public Builder isNearRaid() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_RAID, false);
        }

        public Builder isNotNearRaid() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_RAID, true);
        }

        private Builder inPositionWithState(PositionEnvironment.Value state, boolean invert) {
            return this.in(new PositionEnvironment(state, invert));
        }

        public Builder aboveDifficulty(float percent) {
            return this.in(new SpecialDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL, percent));
        }

        public Builder belowDifficulty(float percent) {
            return this.in(new SpecialDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), percent));
        }

        public Builder isRaining() {
            return this.inWeather(WeatherEnvironment.Value.RAIN, false);
        }

        public Builder isNotRaining() {
            return this.inWeather(WeatherEnvironment.Value.RAIN, true);
        }

        public Builder isThundering() {
            return this.inWeather(WeatherEnvironment.Value.THUNDER, false);
        }

        public Builder isNotThundering() {
            return this.inWeather(WeatherEnvironment.Value.THUNDER, true);
        }

        private Builder inWeather(WeatherEnvironment.Value weather, boolean invert) {
            return this.in(new WeatherEnvironment(weather, invert));
        }

        public Builder atMaxMoonLight() {
            return this.in(new MoonPhaseEnvironment(MoonPhaseEnvironment.Value.FULL, false));
        }

        public Builder aboveHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.GREATER_THAN);
        }

        public Builder atHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.EQUAL_TO);
        }

        public Builder belowHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.LESS_THAN);
        }

        public Builder atNoMoonLight() {
            return this.in(new MoonPhaseEnvironment(MoonPhaseEnvironment.Value.NEW, false));
        }

        private Builder fromHalfMoonLight(ComparisonOperator op) {
            return this.in(new MoonBrightnessEnvironment(op, 0.5f));
        }

        public Builder isNight() {
            return this.in(new DayTimeEnvironment(DayTimeEnvironment.Value.NIGHT, false));
        }

        public Builder isDay() {
            return this.in(new DayTimeEnvironment(DayTimeEnvironment.Value.DAY, false));
        }

        public Builder isNearMidnight() {
            return this.in(new TimeFromMidnightEnvironment(ComparisonOperator.LESS_OR_EQUAL, 1500));
        }

        public Builder isNotNearMidnight() {
            return this.in(new TimeFromMidnightEnvironment(ComparisonOperator.LESS_OR_EQUAL.invert(), 1500));
        }

        public Builder afterDays(int days) {
            return this.in(new WorldTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder beforeDays(int days) {
            return this.in(new WorldTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }

        public Builder afterDaysInChunk(int days) {
            return this.in(new ChunkTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder beforeDaysInChunk(int days) {
            return this.in(new ChunkTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }
    }
}

