/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.EntityEntry;
import fathertoast.specialmobs.common.config.util.IStringArray;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

public class EntityList
implements IStringArray {
    private final EntityEntry[] ENTRIES;
    private int entryValues = -1;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public EntityList(List<EntityEntry> entries) {
        this(entries.toArray(new EntityEntry[0]));
    }

    public EntityList(EntityEntry ... entries) {
        this.ENTRIES = entries;
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EntityList)) {
            return false;
        }
        return this.toStringList().equals(((EntityList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (EntityEntry entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        return list;
    }

    public boolean contains(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        EntityEntry targetEntry = new EntityEntry(entity);
        for (EntityEntry currentEntry : this.ENTRIES) {
            currentEntry.checkClass(entity.field_70170_p);
            if (!currentEntry.contains(targetEntry)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public double[] getValues(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        EntityEntry targetEntry = new EntityEntry(entity);
        EntityEntry bestMatch = null;
        for (EntityEntry currentEntry : this.ENTRIES) {
            currentEntry.checkClass(entity.field_70170_p);
            if (!currentEntry.EXTEND && currentEntry.entityClass == targetEntry.entityClass) {
                return currentEntry.VALUES;
            }
            if (!currentEntry.contains(targetEntry) || bestMatch != null && !bestMatch.contains(currentEntry)) continue;
            bestMatch = currentEntry;
        }
        return bestMatch == null ? null : bestMatch.VALUES;
    }

    public double getValue(@Nullable Entity entity) {
        double[] values = this.getValues(entity);
        return values == null || values.length < 1 ? 0.0 : values[0];
    }

    public boolean rollChance(@Nullable LivingEntity entity) {
        return this.ENTRIES.length > 0 && entity != null && entity.func_70681_au().nextDouble() < this.getValue((Entity)entity);
    }

    public EntityList setSinglePercent() {
        return this.setSingleValue().setRange0to1();
    }

    public EntityList setNoValues() {
        return this.setMultiValue(0);
    }

    public EntityList setSingleValue() {
        return this.setMultiValue(1);
    }

    public EntityList setMultiValue(int numberOfValues) {
        this.entryValues = numberOfValues;
        return this;
    }

    public EntityList setRange0to1() {
        return this.setRange(0.0, 1.0);
    }

    public EntityList setRangePos() {
        return this.setRange(0.0, Double.POSITIVE_INFINITY);
    }

    private EntityList setRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public int getRequiredValues() {
        return this.entryValues;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

