/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityEntry {
    private final AbstractConfigField FIELD;
    public final ResourceLocation ENTITY_KEY;
    public final boolean EXTEND;
    public final double[] VALUES;
    private EntityType<? extends Entity> entityType;
    Class<? extends Entity> entityClass;

    EntityEntry(Entity entity) {
        this.FIELD = null;
        this.ENTITY_KEY = entity.func_200600_R().getRegistryName();
        this.EXTEND = false;
        this.VALUES = null;
        this.entityType = entity.func_200600_R();
        this.entityClass = entity.getClass();
    }

    public EntityEntry(double ... values) {
        this(null, true, values);
    }

    public EntityEntry(@Nullable EntityType<? extends Entity> type, double ... values) {
        this(type, true, values);
    }

    public EntityEntry(@Nullable EntityType<? extends Entity> type, boolean extend, double ... values) {
        this(null, type == null ? null : type.getRegistryName(), extend, values);
        this.entityType = type;
    }

    public EntityEntry(@Nullable AbstractConfigField field, @Nullable ResourceLocation regKey, boolean extend, double ... values) {
        this.FIELD = field;
        this.ENTITY_KEY = regKey;
        this.EXTEND = extend;
        this.VALUES = values;
    }

    private boolean validate() {
        if (this.entityType != null || this.ENTITY_KEY == null) {
            return true;
        }
        if (!ForgeRegistries.ENTITIES.containsKey(this.ENTITY_KEY)) {
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.ENTITY_KEY.toString());
            return false;
        }
        this.entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.ENTITY_KEY);
        return true;
    }

    void checkClass(World world) {
        if (this.validate() && this.entityType != null && this.entityClass == null) {
            try {
                Entity entity = this.entityType.func_200721_a(world);
                if (entity != null) {
                    this.entityClass = entity.getClass();
                    entity.func_70106_y();
                }
            }
            catch (Exception ex) {
                SpecialMobs.LOG.warn("Failed to load class of entity type {}!", this.entityType);
                ex.printStackTrace();
            }
        }
    }

    public boolean contains(EntityEntry entry) {
        if (!this.validate()) {
            return false;
        }
        if (this.entityType == null) {
            return true;
        }
        if (entry.entityType == null) {
            return false;
        }
        if (this.entityClass == entry.entityClass) {
            return !entry.EXTEND;
        }
        if (this.EXTEND) {
            return this.entityClass.isAssignableFrom(entry.entityClass);
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.ENTITY_KEY == null ? "default" : this.ENTITY_KEY.toString());
        if (!this.EXTEND) {
            str.insert(0, '~');
        }
        if (this.VALUES != null && this.VALUES.length > 0) {
            for (double value : this.VALUES) {
                str.append(' ').append(value);
            }
        }
        return str.toString();
    }
}

