/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ConfigUtil {
    public static byte DYNAMIC_REGISTRY_VERSION;
    public static final String PLUS_OR_MINUS = "\u00b1";
    public static final String LESS_OR_EQUAL = "\u2264";
    public static final String GREATER_OR_EQUAL = "\u2265";

    public static String noSpaces(String str) {
        return str.replace(' ', '_');
    }

    public static String camelCaseToLowerSpace(String str) {
        StringBuilder spacedStr = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    spacedStr.append(' ');
                }
                spacedStr.append(Character.toLowerCase(c));
                continue;
            }
            spacedStr.append(c);
        }
        return spacedStr.toString();
    }

    public static String camelCaseToLowerUnderscore(String str) {
        return ConfigUtil.noSpaces(ConfigUtil.camelCaseToLowerSpace(str));
    }

    public static String properCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String toRelativePath(FileConfig configFile) {
        return ConfigUtil.toRelativePath(configFile.getFile());
    }

    public static String toRelativePath(File gameFile) {
        return FMLPaths.GAMEDIR.get().relativize(gameFile.toPath()).toString();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        DYNAMIC_REGISTRY_VERSION = (byte)(DYNAMIC_REGISTRY_VERSION + 1);
    }
}

