/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.BlockEntry;
import fathertoast.specialmobs.common.config.util.IStringArray;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockList
implements IStringArray {
    private final Map<Block, BlockEntry> UNDERLYING_MAP = new HashMap<Block, BlockEntry>();
    private final List<BlockEntry> PRINT_LIST = new ArrayList<BlockEntry>();

    public BlockList(BlockEntry ... entries) {
        for (BlockEntry entry : entries) {
            this.mergeFrom(entry);
        }
    }

    public BlockList(AbstractConfigField field, List<String> entries) {
        for (String line : entries) {
            if (line.endsWith("*")) {
                this.mergeFromNamespace(line.substring(0, line.length() - 1));
                continue;
            }
            BlockEntry entry = new BlockEntry(field, line);
            if (entry.BLOCK == Blocks.field_150350_a) {
                SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Deleting entry. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                continue;
            }
            this.mergeFrom(entry);
        }
    }

    public String toString() {
        return TomlHelper.toLiteral(this.PRINT_LIST.toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BlockList)) {
            return false;
        }
        return this.toStringList().equals(((BlockList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.PRINT_LIST.size());
        for (BlockEntry entry : this.PRINT_LIST) {
            list.add(entry.toString());
        }
        return list;
    }

    public boolean isEmpty() {
        return this.UNDERLYING_MAP.isEmpty();
    }

    public boolean matches(BlockState blockState) {
        BlockEntry entry = this.UNDERLYING_MAP.get(blockState.func_177230_c());
        return entry != null && entry.matches(blockState);
    }

    private void mergeFrom(BlockEntry otherEntry) {
        this.PRINT_LIST.add(otherEntry);
        BlockEntry currentEntry = this.UNDERLYING_MAP.get(otherEntry.BLOCK);
        if (currentEntry == null) {
            this.UNDERLYING_MAP.put(otherEntry.BLOCK, otherEntry);
        } else {
            currentEntry.mergeFrom(otherEntry);
        }
    }

    private void mergeFromNamespace(String namespace) {
        for (ResourceLocation regKey : ForgeRegistries.BLOCKS.getKeys()) {
            Block block;
            if (!regKey.toString().startsWith(namespace) || (block = (Block)ForgeRegistries.BLOCKS.getValue(regKey)) == null || block == Blocks.field_150350_a) continue;
            this.mergeFrom(new BlockEntry(block));
        }
    }
}

