/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockEntry
implements Cloneable {
    public final Block BLOCK;
    private final List<State> MATCHERS = new ArrayList<State>();

    public BlockEntry(Block block) {
        this.BLOCK = block;
    }

    public BlockEntry(BlockState block) {
        this(block.func_177230_c());
        StateBuilder state = new StateBuilder(this.BLOCK);
        for (Property property : block.func_235904_r_()) {
            state.add(property, block.func_177229_b(property));
        }
        if (!state.isEmpty()) {
            this.MATCHERS.add(state.toTargetState());
        }
    }

    public BlockEntry(AbstractConfigField field, String line) {
        State state;
        String[] pair = line.split("\\[", 2);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(pair[0]));
        Block block2 = this.BLOCK = block == null ? Blocks.field_150350_a : block;
        if (this.BLOCK == Blocks.field_150350_a || pair.length < 2) {
            return;
        }
        if (!pair[1].endsWith("]")) {
            SpecialMobs.LOG.info("Adding closing bracket on block state properties for {} \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
            pair[1] = pair[1] + "]";
        }
        if (!(state = BlockEntry.parseState(field, pair[1].substring(0, pair[1].length() - 1), this.BLOCK)).PROPERTIES_TO_MATCH.isEmpty()) {
            this.MATCHERS.add(state);
        }
    }

    public BlockEntry clone() {
        BlockEntry cloned = new BlockEntry(this.BLOCK);
        cloned.MATCHERS.addAll(this.MATCHERS);
        return cloned;
    }

    public String toString() {
        String registryName = SpecialMobs.toString(this.BLOCK);
        if (this.MATCHERS.isEmpty()) {
            return registryName;
        }
        StringBuilder str = new StringBuilder();
        for (State state : this.MATCHERS) {
            str.append(registryName).append("[").append(state.toString()).append("],");
        }
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        ResourceLocation regKey = this.BLOCK.getRegistryName();
        return regKey == null ? 0 : regKey.hashCode();
    }

    public boolean matches(BlockState block) {
        if (this.MATCHERS.isEmpty()) {
            return true;
        }
        for (State state : this.MATCHERS) {
            if (!state.matches(block)) continue;
            return true;
        }
        return false;
    }

    void mergeFrom(BlockEntry other) {
        if (this.MATCHERS.isEmpty()) {
            SpecialMobs.LOG.warn("Ignoring attempt to add redundant block state to config with block state wildcard '{}'", (Object)other);
        } else if (other.MATCHERS.isEmpty()) {
            SpecialMobs.LOG.warn("Adding block state wildcard to config with redundant block state(s) '{}'", (Object)this);
            this.MATCHERS.clear();
        } else {
            this.MATCHERS.addAll(other.MATCHERS);
        }
    }

    private static State parseState(AbstractConfigField field, String stateString, Block block) {
        String[] properties;
        if (stateString.isEmpty()) {
            return new State(Collections.emptyList());
        }
        StateContainer stateContainer = block.func_176194_O();
        StateBuilder builder = new StateBuilder(block);
        for (String combinedEntry : properties = stateString.split(",")) {
            String[] pair = combinedEntry.trim().split("=", 2);
            if (pair.length != 2) {
                SpecialMobs.LOG.warn("Invalid block property for {} \"{}\". Format must be 'property=value'. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)combinedEntry.trim());
                continue;
            }
            if (pair[1].equals("*")) continue;
            Property property = stateContainer.func_185920_a(pair[0]);
            if (property == null) {
                ArrayList<Object> propertyNames = new ArrayList<Object>();
                for (Property allowed : stateContainer.func_177623_d()) {
                    propertyNames.add(allowed.func_177701_a());
                }
                SpecialMobs.LOG.warn("Invalid block property key for {} \"{}\". Valid property keys for '{}' are {}. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)SpecialMobs.toString(block), (Object)TomlHelper.literalList(propertyNames), (Object)combinedEntry.trim());
                continue;
            }
            Optional value = property.func_185929_b(pair[1]);
            if (!value.isPresent()) {
                ArrayList<Object> valueNames = new ArrayList<Object>();
                for (Comparable allowed : property.func_177700_c()) {
                    valueNames.add(property.func_177702_a(BlockEntry.value(allowed)));
                }
                SpecialMobs.LOG.warn("Invalid block property value for {} \"{}\". Valid values for property '{}' are {}. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)property.func_177701_a(), (Object)TomlHelper.literalList(valueNames), (Object)combinedEntry.trim());
                continue;
            }
            builder.add(property, (Comparable)value.get());
        }
        return builder.toTargetState();
    }

    private static <T extends Comparable<T>> T value(Comparable<?> allowed) {
        return (T)allowed;
    }

    public static final class StateBuilder {
        private final Block BLOCK;
        private final Map<Property<? extends Comparable<?>>, Comparable<?>> propertiesToMatch = new HashMap();

        public StateBuilder(Block block) {
            this.BLOCK = block;
        }

        public boolean isEmpty() {
            return this.propertiesToMatch.isEmpty();
        }

        public boolean contains(Property<? extends Comparable<?>> property) {
            return this.propertiesToMatch.containsKey(property);
        }

        public StateBuilder add(Property<? extends Comparable<?>> property, Comparable<?> value) {
            this.propertiesToMatch.put(property, value);
            return this;
        }

        public BlockEntry toBlockEntry() {
            BlockEntry target = new BlockEntry(this.BLOCK);
            if (!this.isEmpty()) {
                target.MATCHERS.add(this.toTargetState());
            }
            return target;
        }

        private State toTargetState() {
            return new State(new ArrayList(this.propertiesToMatch.entrySet()));
        }
    }

    private static final class State {
        private final List<Map.Entry<Property<?>, Comparable<?>>> PROPERTIES_TO_MATCH;

        private State(List<Map.Entry<Property<?>, Comparable<?>>> properties) {
            this.PROPERTIES_TO_MATCH = Collections.unmodifiableList(properties);
        }

        boolean matches(BlockState block) {
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                if (!this.notEqual(block.func_177229_b(entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public BlockState asMatching(BlockState block) {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return block;
            }
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                block = this.withProperty(block, entry.getKey(), entry.getValue());
            }
            return block;
        }

        public String toString() {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                str.append(entry.getKey().func_177701_a()).append("=").append(this.getPropertyName(entry.getKey(), entry.getValue())).append(",");
            }
            return str.substring(0, str.length() - 1);
        }

        private <T extends Comparable<T>> BlockState withProperty(BlockState block, Property<T> property, Comparable<?> value) {
            return (BlockState)block.func_206870_a(property, value);
        }

        private <T extends Comparable<T>> boolean notEqual(T stateValue, Comparable<?> targetValue) {
            return !stateValue.equals(targetValue);
        }

        private <T extends Comparable<T>> String getPropertyName(Property<T> property, Comparable<?> value) {
            return property.func_177702_a(value);
        }
    }
}

