/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.util;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.core.SpecialMobs;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AttributeEntry {
    private final AbstractConfigField FIELD;
    public final ResourceLocation ATTRIBUTE_KEY;
    public final boolean MULTIPLY;
    public final double VALUE;
    private Attribute attribute;

    public static AttributeEntry add(Attribute attribute, double value) {
        if (attribute.equals(Attributes.field_233821_d_)) {
            throw new IllegalArgumentException("Move speed should not be added!");
        }
        return new AttributeEntry(attribute, false, value);
    }

    public static AttributeEntry mult(Attribute attribute, double value) {
        return new AttributeEntry(attribute, true, value);
    }

    private AttributeEntry(Attribute attrib, boolean multiply, double value) {
        this(null, ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attrib), multiply, value);
        this.attribute = attrib;
    }

    public AttributeEntry(@Nullable AbstractConfigField field, @Nullable ResourceLocation regKey, boolean multiply, double value) {
        this.FIELD = field;
        this.ATTRIBUTE_KEY = regKey;
        this.MULTIPLY = multiply;
        this.VALUE = value;
    }

    private boolean validate() {
        if (this.attribute != null) {
            return true;
        }
        if (!ForgeRegistries.ATTRIBUTES.containsKey(this.ATTRIBUTE_KEY)) {
            SpecialMobs.LOG.warn("Invalid entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.ATTRIBUTE_KEY.toString());
            return false;
        }
        this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(this.ATTRIBUTE_KEY);
        return true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.ATTRIBUTE_KEY.toString()).append(' ');
        if (this.MULTIPLY) {
            str.append("* ").append(this.VALUE);
        } else if (this.VALUE < 0.0) {
            str.append("- ").append(-this.VALUE);
        } else {
            str.append("+ ").append(this.VALUE);
        }
        return str.toString();
    }

    public void apply(AttributeModifierMap.MutableAttribute builder) {
        if (this.validate()) {
            this.apply((ModifiableAttributeInstance)builder.field_233811_a_.get(this.attribute));
        }
    }

    public void apply(LivingEntity entity) {
        if (this.validate()) {
            this.apply(entity.func_110148_a(this.attribute));
        }
    }

    private void apply(@Nullable ModifiableAttributeInstance attributeInstance) {
        if (attributeInstance == null) {
            throw new IllegalStateException("Attempted to modify non-registered attribute " + this.ATTRIBUTE_KEY);
        }
        if (this.MULTIPLY) {
            attributeInstance.func_111128_a(attributeInstance.func_111125_b() * this.VALUE);
        } else {
            attributeInstance.func_111128_a(attributeInstance.func_111125_b() + this.VALUE);
        }
    }
}

