/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.IntField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class WildsWitchSpeciesConfig
extends SpeciesConfig {
    public final Wilds WILDS;

    public WildsWitchSpeciesConfig(MobFamily.Species<?> species, int minMounts, int maxMounts, int minSwarms, int maxSwarms, int minSwarmSize, int maxSwarmSize) {
        super(species);
        this.WILDS = new Wilds(this.SPEC, species, species.getConfigName(), minMounts, maxMounts, minSwarms, maxSwarms, minSwarmSize, maxSwarmSize);
    }

    public static class Wilds
    extends Config.AbstractCategory {
        public final IntField.RandomRange mounts;
        public final IntField.RandomRange swarms;
        public final IntField.RandomRange swarmSize;

        Wilds(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, int minMounts, int maxMounts, int minSwarms, int maxSwarms, int minSwarmSize, int maxSwarmSize) {
            super(parent, ConfigUtil.camelCaseToLowerUnderscore(species.specialVariantName), "Options specific to " + speciesName + ".");
            this.mounts = new IntField.RandomRange(this.SPEC.define(new IntField("mounts.min", minMounts, IntField.Range.NON_NEGATIVE, "The minimum and maximum (inclusive) number of times " + speciesName + " can summon a spider mount.")), this.SPEC.define(new IntField("mounts.max", maxMounts, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.swarms = new IntField.RandomRange(this.SPEC.define(new IntField("swarms.min", minSwarms, IntField.Range.NON_NEGATIVE, "The minimum and maximum (inclusive) number of times " + speciesName + " can summon a spider swarm.")), this.SPEC.define(new IntField("swarms.max", maxSwarms, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.swarmSize = new IntField.RandomRange(this.SPEC.define(new IntField("swarm_size.min", minSwarmSize, IntField.Range.NON_NEGATIVE, "The minimum and maximum (inclusive) number of spiders " + speciesName + " spawn with each swarm.", "Note that this is rolled on the summoner's spawn, not each time a swarm is summoned.")), this.SPEC.define(new IntField("swarm_size.max", maxSwarmSize, IntField.Range.NON_NEGATIVE, new String[0])));
        }
    }
}

