/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class SpiderSpeciesConfig
extends SpeciesConfig {
    public final Spiders SPIDERS;

    public SpiderSpeciesConfig(MobFamily.Species<?> species, double spitChance) {
        super(species);
        this.SPIDERS = new Spiders(this.SPEC, species, species.getConfigName(), spitChance);
    }

    public static class Spiders
    extends Config.AbstractCategory {
        public final DoubleField spitterChance;

        Spiders(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, double spitChance) {
            super(parent, ConfigUtil.noSpaces(species.family.configName), "Options standard to all " + species.family.configName + ".");
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? spitChance : 0.0;
            this.spitterChance = this.SPEC.define(new DoubleField("spitter_chance", effectiveDefault, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn as a 'spitter', which enables their ranged attack (if max range > 0)."));
        }
    }
}

