/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class SkeletonSpeciesConfig
extends SpeciesConfig {
    public final Skeletons SKELETONS;

    public SkeletonSpeciesConfig(MobFamily.Species<?> species, double bowChance, double shieldChance) {
        super(species);
        this.SKELETONS = new Skeletons(this.SPEC, species, species.getConfigName(), bowChance, shieldChance);
    }

    public static class Skeletons
    extends Config.AbstractCategory {
        public final DoubleField bowEquipChance;
        public final DoubleField shieldEquipChance;

        Skeletons(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, double bowChance, double shieldChance) {
            super(parent, ConfigUtil.noSpaces(species.family.configName), "Options standard to all " + species.family.configName + ".");
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? bowChance : 0.0;
            this.bowEquipChance = this.SPEC.define(new DoubleField("bow_chance", effectiveDefault, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn with a bow, which enables their ranged attack (if max range > 0)."));
            this.SPEC.newLine();
            this.shieldEquipChance = this.SPEC.define(new DoubleField("shield_chance", shieldChance, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn with a shield if they did not spawn with a bow.", "Shield users have a 33% chance to block frontal attacks (100% vs. long range attacks) and can be broken by axes."));
        }
    }
}

