/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class SilverfishSpeciesConfig
extends SpeciesConfig {
    public final Silverfish SILVERFISH;

    public SilverfishSpeciesConfig(MobFamily.Species<?> species, double spitChance) {
        super(species);
        this.SILVERFISH = new Silverfish(this.SPEC, species, species.getConfigName(), spitChance);
    }

    public static class Silverfish
    extends Config.AbstractCategory {
        public final DoubleField aggressiveChance;
        public final DoubleField spitterChance;

        Silverfish(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, double spitChance) {
            super(parent, ConfigUtil.noSpaces(species.family.configName), "Options standard to all " + species.family.configName + ".");
            this.aggressiveChance = this.SPEC.define(new DoubleField("aggressive_chance", -1.0, DoubleField.Range.SIGNED_PERCENT, "Chance for " + speciesName + " to spawn already calling for reinforcements.", "If this is set to a non-negative value, it overrides the value set for \"family_aggressive_chance\"."));
            this.SPEC.newLine();
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? spitChance : 0.0;
            this.spitterChance = this.SPEC.define(new DoubleField("spitter_chance", effectiveDefault, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn as a 'spitter', which enables their ranged attack (if max range > 0)."));
        }
    }
}

