/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class DrownedSpeciesConfig
extends SpeciesConfig {
    public final Drowned DROWNED;

    public DrownedSpeciesConfig(MobFamily.Species<?> species, double tridentChance, double shieldChance) {
        super(species);
        this.DROWNED = new Drowned(this.SPEC, species, species.getConfigName(), tridentChance, shieldChance);
    }

    public static class Drowned
    extends Config.AbstractCategory {
        public final DoubleField tridentEquipChance;
        public final DoubleField shieldEquipChance;

        Drowned(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, double tridentChance, double shieldChance) {
            super(parent, ConfigUtil.noSpaces(species.family.configName), "Options standard to all " + species.family.configName + ".");
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? tridentChance : 0.0;
            this.tridentEquipChance = this.SPEC.define(new DoubleField("trident_chance", effectiveDefault, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn with a trident, which enables their ranged attack (if max range > 0)."));
            this.SPEC.newLine();
            this.shieldEquipChance = this.SPEC.define(new DoubleField("shield_chance", shieldChance, DoubleField.Range.PERCENT, "Chance for " + speciesName + " to spawn with a shield.", "Shield users have a 33% chance to block frontal attacks (100% vs. long range attacks) and can be broken by axes."));
        }
    }
}

