/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.IntField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;

public class CorporealShiftGhastSpeciesConfig
extends SpeciesConfig {
    public final CorporealShift CORPOREAL_SHIFT;

    public CorporealShiftGhastSpeciesConfig(MobFamily.Species<?> species, int corporealTime, int incorporealTime) {
        super(species);
        this.CORPOREAL_SHIFT = new CorporealShift(this.SPEC, species, species.getConfigName(), corporealTime, incorporealTime);
    }

    public static class CorporealShift
    extends Config.AbstractCategory {
        public final IntField corporealTicks;
        public final IntField incorporealTicks;

        CorporealShift(ToastConfigSpec parent, MobFamily.Species<?> species, String speciesName, int corporealTime, int incorporealTime) {
            super(parent, ConfigUtil.camelCaseToLowerUnderscore(species.specialVariantName), "Options specific to " + speciesName + ".");
            this.corporealTicks = this.SPEC.define(new IntField("ticks.corporeal", corporealTime, IntField.Range.NON_NEGATIVE, "The number of ticks " + speciesName + " stay in 'corporeal' mode before shifting (20 ticks = 1 second).", "In corporeal mode, " + speciesName + " can be damaged and shoot like normal " + species.family.configName + "."));
            this.incorporealTicks = this.SPEC.define(new IntField("ticks.incorporeal", incorporealTime, IntField.Range.NON_NEGATIVE, "The number of ticks " + speciesName + " stay in 'incorporeal' mode before shifting (20 ticks = 1 second).", "In incorporeal mode, " + speciesName + " are immune to damage and shoot unique fireballs that punish movement."));
        }
    }
}

