/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.file;

import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.utils.StringUtils;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.field.IntField;
import fathertoast.specialmobs.common.config.util.IStringArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class TomlHelper {
    private TomlHelper() {
    }

    public static List<String> parseStringList(Object value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value instanceof List) {
            for (Object entry : (List)value) {
                if (entry == null) continue;
                list.add(entry.toString());
            }
        } else {
            list.add(TomlHelper.toLiteral(value));
        }
        return list;
    }

    public static Object parseRaw(@Nullable String value) {
        block4: {
            if (value != null && !"".equals(value)) {
                try {
                    return Double.parseDouble(value);
                }
                catch (NumberFormatException numberFormatException) {
                    if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                        return Boolean.TRUE;
                    }
                    if (!Boolean.FALSE.toString().equalsIgnoreCase(value)) break block4;
                    return Boolean.FALSE;
                }
            }
        }
        return NullObject.NULL_OBJECT;
    }

    public static String toLiteralForComment(@Nullable Object value) {
        List<String> list;
        if (value instanceof IStringArray && (list = ((IStringArray)value).toStringList()).size() > 10) {
            String str = TomlHelper.toLiteral(list.subList(0, 9).toArray());
            return str.substring(0, str.length() - 2) + ", ... ]";
        }
        return TomlHelper.toLiteral(value);
    }

    public static String toLiteral(@Nullable Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Enum) {
            return "\"" + ((Enum)value).name().toLowerCase() + "\"";
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }

    public static String toLiteral(Object ... values) {
        if (values == null) {
            return "";
        }
        if (values.length < 1) {
            return "[]";
        }
        return "[ " + TomlHelper.literalList(values) + " ]";
    }

    public static String literalList(Object ... list) {
        return TomlHelper.literalList(Arrays.asList(list));
    }

    public static String literalList(@Nullable List<Object> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder literals = new StringBuilder();
        for (Object obj : list) {
            literals.append(TomlHelper.toLiteral(obj)).append(", ");
        }
        literals.delete(literals.length() - 2, literals.length());
        return literals.toString();
    }

    public static String fieldInfoFormat(String typeName, Object defaultValue, String format) {
        return String.format("<%s> Format: %s, Default: %s", typeName, format, TomlHelper.toLiteralForComment(defaultValue));
    }

    public static String fieldInfoValidValues(String typeName, Object defaultValue, Object ... validValues) {
        return String.format("<%s> Valid Values: { %s }, Default: %s", typeName, TomlHelper.literalList(validValues), TomlHelper.toLiteralForComment(defaultValue));
    }

    public static String multiFieldInfo(IntField.Range range) {
        return TomlHelper.multiFieldInfo(range.MIN, range.MAX);
    }

    public static String multiFieldInfo(int min, int max) {
        return String.format("<%s> Range: %s", "Integer", TomlHelper.fieldRange(min, max));
    }

    public static String multiFieldInfo(DoubleField.Range range) {
        return TomlHelper.multiFieldInfo(range.MIN, range.MAX);
    }

    public static String multiFieldInfo(double min, double max) {
        return String.format("<%s> Range: %s", "Number", TomlHelper.fieldRange(min, max));
    }

    public static String fieldInfoRange(int defaultValue, int min, int max) {
        return TomlHelper.fieldInfoRange("Integer", TomlHelper.fieldRange(min, max), (Number)defaultValue);
    }

    public static String fieldInfoRange(double defaultValue, double min, double max) {
        return TomlHelper.fieldInfoRange("Number", TomlHelper.fieldRange(min, max), (Number)defaultValue);
    }

    private static String fieldInfoRange(String typeName, String range, Number defaultValue) {
        return String.format("<%s> Range: %s, Default: %s", typeName, range, TomlHelper.toLiteral((Object)defaultValue));
    }

    public static String fieldRange(int min, int max) {
        if (min == Integer.MIN_VALUE) {
            if (max == Integer.MAX_VALUE) {
                return TomlHelper.fieldRangeNoLimit();
            }
            return TomlHelper.fieldRangeUpperLimit(max);
        }
        if (max == Integer.MAX_VALUE) {
            return TomlHelper.fieldRangeLowerLimit(min);
        }
        return TomlHelper.fieldRangeInterval(min, max);
    }

    public static String fieldRange(double min, double max) {
        if (min <= -1.7976931348623157E308) {
            if (max >= Double.MAX_VALUE) {
                return TomlHelper.fieldRangeNoLimit();
            }
            return TomlHelper.fieldRangeUpperLimit(max);
        }
        if (max >= Double.MAX_VALUE) {
            return TomlHelper.fieldRangeLowerLimit(min);
        }
        return TomlHelper.fieldRangeInterval(min, max);
    }

    private static String fieldRangeNoLimit() {
        return "Any Value";
    }

    private static String fieldRangeUpperLimit(Number max) {
        return "\u2264 " + TomlHelper.toLiteral((Object)max);
    }

    private static String fieldRangeLowerLimit(Number min) {
        return "\u2265 " + TomlHelper.toLiteral((Object)min);
    }

    private static String fieldRangeInterval(Number min, Number max) {
        return TomlHelper.toLiteral((Object)min) + " ~ " + TomlHelper.toLiteral((Object)max);
    }

    public static List<String> splitKey(String key) {
        return StringUtils.split((String)key, (char)'.');
    }

    public static String mergePath(@Nullable List<String> path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        for (String subKey : path) {
            key.append(subKey).append('.');
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }

    public static ArrayList<String> newComment(String ... lines) {
        return new ArrayList<String>(Arrays.asList(lines));
    }

    public static String combineList(Object ... list) {
        return TomlHelper.combineList(Arrays.asList(list));
    }

    public static String combineList(@Nullable List<Object> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        for (Object obj : list) {
            key.append(obj).append(", ");
        }
        key.delete(key.length() - 2, key.length());
        return key.toString();
    }
}

