/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.file;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.io.IndentStyle;
import com.electronwill.nightconfig.core.io.NewlineStyle;
import com.electronwill.nightconfig.core.io.WriterOutput;
import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;

public class ToastTomlWriter
implements ConfigWriter {
    private static final char[] CHARS_INDENT = IndentStyle.TABS.chars;
    private static final char[] CHARS_NEW_LINE = NewlineStyle.system().chars;
    private static final char[] CHARS_COMMENT = new char[]{'#', ' '};
    private static final char[] CHARS_ASSIGN = new char[]{' ', '=', ' '};
    private int currentIndentLevel;
    private boolean skipNextIndent;
    private final ToastConfigSpec CONFIG_SPEC;

    ToastTomlWriter(ToastConfigSpec spec) {
        this.CONFIG_SPEC = spec;
    }

    public void write(UnmodifiableConfig config, Writer writer) {
        this.CONFIG_SPEC.writing = true;
        SpecialMobs.LOG.debug("Writing config file! ({}{})", (Object)this.CONFIG_SPEC.NAME, (Object)".toml");
        WriterOutput output = new WriterOutput(writer);
        this.currentIndentLevel = 0;
        this.CONFIG_SPEC.write(this, (CharacterOutput)output);
        this.CONFIG_SPEC.writing = false;
    }

    public void increaseIndentLevel() {
        this.changeIndentLevel(1);
    }

    public void decreaseIndentLevel() {
        this.changeIndentLevel(-1);
    }

    public void changeIndentLevel(int amount) {
        this.currentIndentLevel += amount;
    }

    private void writeIndent(CharacterOutput output) {
        if (this.skipNextIndent) {
            this.skipNextIndent = false;
        } else {
            for (int i = 0; i < this.currentIndentLevel; ++i) {
                output.write(CHARS_INDENT);
            }
        }
    }

    public void continueLine() {
        this.skipNextIndent = true;
    }

    public void writeNewLine(CharacterOutput output) {
        output.write(CHARS_NEW_LINE);
    }

    public void writeLine(String line, CharacterOutput output) {
        this.writeIndent(output);
        output.write(line);
        this.writeNewLine(output);
    }

    public void writeStringArray(@Nullable List<String> list, CharacterOutput output) {
        if (list == null || list.isEmpty()) {
            this.writeLine("[]", output);
            return;
        }
        this.writeLine("[", output);
        this.increaseIndentLevel();
        ListIterator<String> itr = list.listIterator();
        while (itr.hasNext()) {
            this.writeIndent(output);
            output.write(String.format("\"%s\"", itr.next()));
            if (itr.hasNext()) {
                output.write(',');
            }
            this.writeNewLine(output);
        }
        this.decreaseIndentLevel();
        this.writeLine("]", output);
    }

    public void writeComment(List<String> comment, CharacterOutput output) {
        for (String line : comment) {
            this.writeComment(line, output);
        }
    }

    public void writeComment(String comment, CharacterOutput output) {
        this.writeIndent(output);
        output.write(CHARS_COMMENT);
        output.write(comment);
        this.writeNewLine(output);
    }

    public void writeField(AbstractConfigField field, CharacterOutput output) {
        if (field.getComment() != null) {
            this.writeComment(field.getComment(), output);
        }
        this.writeIndent(output);
        output.write(field.getKey());
        output.write(CHARS_ASSIGN);
        this.continueLine();
        field.writeValue(this, output);
    }
}

