/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.file;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileConfigBuilder;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingException;
import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.field.AttributeListField;
import fathertoast.specialmobs.common.config.field.BlockListField;
import fathertoast.specialmobs.common.config.field.EntityListField;
import fathertoast.specialmobs.common.config.field.EnvironmentListField;
import fathertoast.specialmobs.common.config.field.RegistryEntryListField;
import fathertoast.specialmobs.common.config.file.ToastConfigFormat;
import fathertoast.specialmobs.common.config.file.ToastTomlWriter;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.config.util.RestartNote;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ToastConfigSpec {
    public static volatile boolean freezeFileWatcher;
    public final File DIR;
    public final String NAME;
    public final FileConfig CONFIG_FILE;
    private final List<Action> ACTIONS = new ArrayList<Action>();
    private volatile boolean initialized;
    volatile boolean writing;

    public ToastConfigSpec(File dir, String fileName) {
        this.DIR = dir;
        this.NAME = fileName;
        if (!dir.exists() && !dir.mkdirs()) {
            SpecialMobs.LOG.error("Failed to make config folder! Things will likely explode. Create the folder manually to avoid this problem in the future: {}", (Object)dir);
        }
        FileConfigBuilder builder = FileConfig.builder((File)new File(dir, fileName + ".toml"), (ConfigFormat)new ToastConfigFormat(this));
        this.CONFIG_FILE = builder.sync().build();
        if (!this.CONFIG_FILE.getFile().exists()) {
            SpecialMobs.LOG.info("Generating default config file {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
            try {
                if (!this.CONFIG_FILE.getFile().createNewFile()) {
                    SpecialMobs.LOG.error("Failed to make config file! Things will likely explode. Create the file manually to avoid this problem in the future: {}", (Object)dir);
                }
            }
            catch (IOException ex) {
                SpecialMobs.LOG.error("Caught exception while generating blank config file! Things will likely explode. Create the file manually to avoid this problem in the future: {}", (Object)dir, (Object)ex);
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        SpecialMobs.LOG.info("First-time loading config file {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        try {
            this.CONFIG_FILE.load();
        }
        catch (ParsingException ex) {
            SpecialMobs.LOG.error("Failed first-time loading of config file {} - this is bad!", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        }
        try {
            FileWatcher.defaultInstance().addWatch(this.CONFIG_FILE.getFile(), this::onFileChanged);
            SpecialMobs.LOG.info("Started watching config file {} for updates", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        }
        catch (IOException ex) {
            SpecialMobs.LOG.error("Failed to watch config file {} - this file will NOT update in-game until restarted!", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        }
        this.initialized = true;
    }

    public void onFileChanged() {
        if (this.writing) {
            SpecialMobs.LOG.debug("Skipping config file reload (it is currently saving) {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        } else if (freezeFileWatcher) {
            SpecialMobs.LOG.debug("Skipping config file reload (file watcher paused) {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        } else {
            SpecialMobs.LOG.info("Reloading config file {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
            try {
                this.CONFIG_FILE.load();
            }
            catch (ParsingException ex) {
                SpecialMobs.LOG.error("Failed to reload config file {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
            }
        }
    }

    public void onLoad() {
        boolean rewrite = false;
        for (Action action : this.ACTIONS) {
            if (!action.onLoad()) continue;
            rewrite = true;
        }
        if (rewrite) {
            this.save();
        }
    }

    private void save() {
        try {
            this.CONFIG_FILE.save();
        }
        catch (WritingException ex) {
            SpecialMobs.LOG.error("Failed to save config file {}", (Object)ConfigUtil.toRelativePath(this.CONFIG_FILE));
        }
    }

    public void write(ToastTomlWriter writer, CharacterOutput output) {
        for (Action action : this.ACTIONS) {
            action.write(writer, output);
        }
    }

    public <T extends AbstractConfigField> T define(T field) {
        return this.define(field, null);
    }

    public <T extends AbstractConfigField> T define(T field, @Nullable RestartNote restartNote) {
        for (Action action : this.ACTIONS) {
            if (!(action instanceof Field) || !field.getKey().equalsIgnoreCase(((Field)action).FIELD.getKey())) continue;
            throw new IllegalStateException("Attempted to register duplicate field key '" + field.getKey() + "' in config " + this.NAME);
        }
        this.ACTIONS.add(new Field(this, field, restartNote));
        return field;
    }

    public void callback(Runnable callback) {
        this.ACTIONS.add(new ReadCallback(callback));
    }

    public void newLine() {
        this.newLine(1);
    }

    public void newLine(int count) {
        this.ACTIONS.add(new NewLines(count));
    }

    public void increaseIndent() {
        this.indent(1);
    }

    public void decreaseIndent() {
        this.indent(-1);
    }

    public void indent(int count) {
        this.ACTIONS.add(new Indent(count));
    }

    public void comment(String ... comment) {
        this.comment(TomlHelper.newComment(comment));
    }

    public void comment(List<String> comment) {
        this.ACTIONS.add(new Comment(comment));
    }

    public void subcategory(String name, String ... comment) {
        this.ACTIONS.add(new Subcategory(name, TomlHelper.newComment(comment)));
    }

    public void appendixHeader(String ... comment) {
        this.ACTIONS.add(new AppendixHeader(TomlHelper.newComment(comment)));
    }

    public void describeRegistryEntryList() {
        this.ACTIONS.add(new Comment(RegistryEntryListField.verboseDescription()));
    }

    public void describeEntityList() {
        this.ACTIONS.add(new Comment(EntityListField.verboseDescription()));
    }

    public void describeAttributeList() {
        this.ACTIONS.add(new Comment(AttributeListField.verboseDescription()));
    }

    public void describeBlockList() {
        this.ACTIONS.add(new Comment(BlockListField.verboseDescription()));
    }

    public void describeEnvironmentListPart1of2() {
        this.ACTIONS.add(new Comment(EnvironmentListField.verboseDescription()));
    }

    public void describeEnvironmentListPart2of2() {
        this.ACTIONS.add(new Comment(EnvironmentListField.environmentDescriptions()));
    }

    public void header(List<String> comment) {
        this.ACTIONS.add(new Header(this, comment));
    }

    public void category(String name, List<String> comment) {
        this.ACTIONS.add(new Category(name, comment));
    }

    private static class Field
    implements Action {
        private final ToastConfigSpec PARENT;
        private final AbstractConfigField FIELD;

        private Field(ToastConfigSpec parent, AbstractConfigField field, @Nullable RestartNote restartNote) {
            this.PARENT = parent;
            this.FIELD = field;
            this.FIELD.finalizeComment(restartNote);
        }

        @Override
        public boolean onLoad() {
            Object oldRaw = this.FIELD.getRaw();
            Object rawToml = this.PARENT.CONFIG_FILE.getOptional(this.FIELD.getKey()).orElse(null);
            this.FIELD.load(rawToml);
            Object newRaw = this.FIELD.getRaw();
            if (rawToml == null || !Objects.equals(oldRaw, newRaw)) {
                this.PARENT.CONFIG_FILE.set(this.FIELD.getKey(), newRaw);
                return true;
            }
            return false;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.writeField(this.FIELD, output);
        }
    }

    private static class ReadCallback
    implements Action {
        private final Runnable CALLBACK;

        private ReadCallback(Runnable callback) {
            this.CALLBACK = callback;
        }

        @Override
        public boolean onLoad() {
            this.CALLBACK.run();
            return false;
        }

        @Override
        public final void write(ToastTomlWriter writer, CharacterOutput output) {
        }
    }

    private static class Subcategory
    extends Format {
        private final List<String> COMMENT;

        private Subcategory(String subcategoryName, List<String> comment) {
            comment.add(0, "Subcategory: " + subcategoryName);
            this.COMMENT = comment;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
            writer.writeNewLine(output);
        }
    }

    private static class Category
    extends Format {
        private final List<String> COMMENT;

        private Category(String categoryName, List<String> comment) {
            comment.add(0, "Category: " + categoryName);
            this.COMMENT = comment;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeNewLine(output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
            writer.writeNewLine(output);
        }
    }

    private static class AppendixHeader
    extends Format {
        private final List<String> COMMENT;

        private AppendixHeader(List<String> comment) {
            this.COMMENT = comment;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeNewLine(output);
            writer.writeComment("Appendix:", output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
        }
    }

    private static class Header
    extends Format {
        private final ToastConfigSpec PARENT;
        private final List<String> COMMENT;

        private Header(ToastConfigSpec parent, List<String> comment) {
            this.PARENT = parent;
            this.COMMENT = comment;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.writeComment("specialmobs:" + this.PARENT.NAME + ".toml", output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
        }
    }

    private static class Comment
    extends Format {
        private final List<String> COMMENT;

        private Comment(List<String> comment) {
            this.COMMENT = comment;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.writeComment(this.COMMENT, output);
        }
    }

    private static class Indent
    extends Format {
        private final int AMOUNT;

        private Indent(int amount) {
            this.AMOUNT = amount;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            writer.changeIndentLevel(this.AMOUNT);
        }
    }

    private static class NewLines
    extends Format {
        private final int COUNT;

        private NewLines(int count) {
            this.COUNT = count;
        }

        @Override
        public void write(ToastTomlWriter writer, CharacterOutput output) {
            for (int i = 0; i < this.COUNT; ++i) {
                writer.writeNewLine(output);
            }
        }
    }

    private static abstract class Format
    implements Action {
        private Format() {
        }

        @Override
        public final boolean onLoad() {
            return false;
        }

        @Override
        public abstract void write(ToastTomlWriter var1, CharacterOutput var2);
    }

    private static interface Action {
        public boolean onLoad();

        public void write(ToastTomlWriter var1, CharacterOutput var2);
    }
}

