/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.DoubleField;
import javax.annotation.Nullable;

public class ScaledDoubleField
extends DoubleField {
    private final double SCALE;
    private double valueScaled;

    public ScaledDoubleField(String key, double defaultValue, double scale, DoubleField.Range range, String ... description) {
        super(key, defaultValue, range, description);
        this.SCALE = scale;
    }

    public ScaledDoubleField(String key, double defaultValue, double scale, double min, double max, String ... description) {
        super(key, defaultValue, min, max, description);
        this.SCALE = scale;
    }

    @Override
    public void load(@Nullable Object raw) {
        super.load(raw);
        this.valueScaled = super.get() * this.SCALE;
    }

    @Override
    public double get() {
        return this.valueScaled;
    }

    public double getUnscaled() {
        return super.get();
    }

    public static class Rate
    extends ScaledDoubleField {
        private static final double PER_SECOND_TO_PER_TICK = 0.05;

        public Rate(String key, double defaultValue, DoubleField.Range range, String ... description) {
            super(key, defaultValue, 0.05, range, description);
        }

        public Rate(String key, double defaultValue, double min, double max, String ... description) {
            super(key, defaultValue, 0.05, min, max, description);
        }
    }
}

