/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.RegistryEntryList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryEntryListField<T extends IForgeRegistryEntry<T>>
extends GenericField<RegistryEntryList<T>> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Registry Entry List fields: General format = [ \"namespace:entry_name\", ... ]");
        comment.add("  Registry entry lists are arrays of registry keys. Many things in the game, such as blocks or potions, are defined");
        comment.add("    by their registry key within a registry. For example, all items are registered in the \"minecraft:item\" registry.");
        comment.add("  An asterisk '*' can be used to match multiple registry keys. For example, 'minecraft:*' will match all vanilla entries");
        comment.add("    within the registry entry list's target registry.");
        return comment;
    }

    public RegistryEntryListField(String key, RegistryEntryList<T> defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("\"" + SpecialMobs.toString(((RegistryEntryList)this.valueDefault).getRegistry().getRegistryName()) + "\" Registry List", this.valueDefault, "[ \"namespace:entry_name\", ... ]"));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        this.value = new RegistryEntryList(this, ((RegistryEntryList)this.valueDefault).getRegistry(), TomlHelper.parseStringList(raw));
    }

    public IForgeRegistry<T> getRegistry() {
        return ((RegistryEntryList)this.get()).getRegistry();
    }

    public Set<T> getEntries() {
        return ((RegistryEntryList)this.get()).getEntries();
    }

    public boolean isEmpty() {
        return ((RegistryEntryList)this.get()).isEmpty();
    }

    public boolean contains(@Nullable T entry) {
        return ((RegistryEntryList)this.get()).contains(entry);
    }
}

