/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class IntField
extends AbstractConfigField {
    private final int valueDefault;
    private final int valueMin;
    private final int valueMax;
    private int value;

    public IntField(String key, int defaultValue, Range range, String ... description) {
        this(key, defaultValue, range.MIN, range.MAX, description);
    }

    public IntField(String key, int defaultValue, int min, int max, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
        this.valueMin = min;
        this.valueMax = max;
    }

    public int get() {
        return this.value;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoRange(this.valueDefault, this.valueMin, this.valueMax));
    }

    @Override
    public void load(@Nullable Object raw) {
        int newValue;
        if (raw instanceof Number) {
            int rawValue = ((Number)raw).intValue();
            if (rawValue < this.valueMin) {
                SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMin, raw);
                newValue = this.valueMin;
            } else if (rawValue > this.valueMax) {
                SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMax, raw);
                newValue = this.valueMax;
            } else {
                if ((double)rawValue != ((Number)raw).doubleValue()) {
                    SpecialMobs.LOG.warn("Value for {} \"{}\" is not an integer! Truncating value. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
                }
                newValue = rawValue;
            }
        } else {
            if (raw instanceof String) {
                SpecialMobs.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
                this.load(TomlHelper.parseRaw((String)raw));
                return;
            }
            if (raw != null) {
                SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            newValue = this.valueDefault;
        }
        this.value = newValue;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }

    public static class RandomRange {
        private final IntField MINIMUM;
        private final IntField MAXIMUM;

        public RandomRange(IntField minimum, IntField maximum) {
            this.MINIMUM = minimum;
            this.MAXIMUM = maximum;
            if (minimum.valueDefault > maximum.valueDefault) {
                throw new IllegalArgumentException(String.format("Random range has inverted default values! (%s > %s) See: (%s, %s)", minimum.valueDefault, maximum.valueDefault, minimum.getKey(), maximum.getKey()));
            }
        }

        public int getMin() {
            return this.MINIMUM.get();
        }

        public int getMax() {
            return this.MAXIMUM.get();
        }

        public int next(Random random) {
            int delta = this.getMax() - this.getMin();
            if (delta > 0) {
                return this.getMin() + random.nextInt(delta + 1);
            }
            if (delta < 0) {
                SpecialMobs.LOG.warn("Value for range \"({},{})\" is invalid ({} > {})! Ignoring maximum value.", (Object)this.MINIMUM.getKey(), (Object)this.MAXIMUM.getKey(), (Object)this.getMin(), (Object)this.getMax());
            }
            return this.getMin();
        }
    }

    public static enum Range {
        ANY(Integer.MIN_VALUE, Integer.MAX_VALUE),
        POSITIVE(1, Integer.MAX_VALUE),
        NON_NEGATIVE(0, Integer.MAX_VALUE),
        TOKEN_NEGATIVE(-1, Integer.MAX_VALUE);

        public final int MIN;
        public final int MAX;

        private Range(int min, int max) {
            this.MIN = min;
            this.MAX = max;
        }
    }
}

