/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import fathertoast.specialmobs.common.config.util.environment.AbstractEnvironment;
import fathertoast.specialmobs.common.config.util.environment.ComparisonOperator;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategoryEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeGroupEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeTemperatureEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.RainfallEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TemperatureEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TerrainDepthEnvironment;
import fathertoast.specialmobs.common.config.util.environment.biome.TerrainScaleEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionPropertyEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionTypeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.dimension.DimensionTypeGroupEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.PositionEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.StructureEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.StructureGroupEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.YEnvironment;
import fathertoast.specialmobs.common.config.util.environment.position.YFromSeaEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.ChunkTimeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.DayTimeEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.DifficultyEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.MoonBrightnessEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.MoonPhaseEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.SpecialDifficultyEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.TimeFromMidnightEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.WeatherEnvironment;
import fathertoast.specialmobs.common.config.util.environment.time.WorldTimeEnvironment;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnvironmentListField
extends GenericField<EnvironmentList> {
    public static final String ENV_DIMENSION_PROPERTY = "dimension_property";
    public static final String ENV_DIMENSION_TYPE = "dimension_type";
    public static final String ENV_TERRAIN_DEPTH = "terrain_depth";
    public static final String ENV_TERRAIN_SCALE = "terrain_scale";
    public static final String ENV_RAINFALL = "rainfall";
    public static final String ENV_BIOME_TEMPERATURE = "biome_temp";
    public static final String ENV_TEMPERATURE = "temp";
    public static final String ENV_BIOME_CATEGORY = "biome_category";
    public static final String ENV_BIOME = "biome";
    public static final String ENV_STRUCTURE = "structure";
    public static final String ENV_Y = "y";
    public static final String ENV_Y_FROM_SEA = "y_from_sea";
    public static final String ENV_POSITION = "position";
    public static final String ENV_DIFFICULTY = "difficulty";
    public static final String ENV_SPECIAL_DIFFICULTY = "special_difficulty";
    public static final String ENV_WEATHER = "weather";
    public static final String ENV_MOON_BRIGHTNESS = "moon_brightness";
    public static final String ENV_MOON_PHASE = "moon_phase";
    public static final String ENV_DAY_TIME = "day_time";
    public static final String ENV_TIME_FROM_MIDNIGHT = "time_from_midnight";
    public static final String ENV_WORLD_TIME = "world_time";
    public static final String ENV_CHUNK_TIME = "chunk_time";

    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Environment List fields: General format = [ \"value environment1 condition1 & environment2 condition2 & ...\", ... ]");
        comment.add("  Environment lists are arrays of environment entries. Each entry is a value followed by the environment conditions that must be");
        comment.add("    satisfied for the value to be chosen. The environments are tested in the order listed, and the first matching entry is chosen.");
        comment.add("  See the bottom of this file for an explanation on each environment condition available.");
        return comment;
    }

    public static List<String> environmentDescriptions() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Environment conditions (for Environment List entries):");
        comment.add("  Many environment conditions can be inverted by using \"!\"; these are shown with (!) in the appropriate location.");
        comment.add("  Other environment conditions are numerical comparisons; these use the operators (shown as op) <, >, =, <=, >=, or != to compare value.");
        comment.add("Valid environment conditions are:");
        comment.add("  \"dimension_property (!)property\":");
        comment.add("    Valid property values: " + TomlHelper.literalList((Object[])DimensionPropertyEnvironment.Value.values()));
        comment.add("    Dimension properties are the true/false values available to dimension types in data packs.");
        comment.add("    See the wiki for more info: [https://minecraft.fandom.com/wiki/Custom_dimension#Syntax].");
        comment.add("  \"dimension_type (!)namespace:dimension_type_name\":");
        comment.add("    The world's dimension type. In vanilla, these are only \"minecraft:overworld\", \"minecraft:the_nether\", or \"minecraft:the_end\".");
        comment.add("  \"terrain_depth op value\":");
        comment.add("    Biome's depth parameter. A measure of how high the terrain generates; depth < 0 makes a watery biome. For reference, generally vanilla");
        comment.add("      plateaus are 1.5, mountains are 1, plains are 0.125, swamps are -0.2, rivers are -0.5, oceans are -1, and deep oceans are -1.8.");
        comment.add("  \"terrain_scale op value\":");
        comment.add("    Biome's scale parameter. A measure of how 'wavy' the terrain generates. For reference, generally vanilla mountains are 0.5 and plains are 0.05.");
        comment.add("  \"rainfall op value\":");
        comment.add("    Biome's rainfall parameter. If this is \"= 0\", it checks that rain is disabled. For reference, rainfall > 0.85 suppresses fire.");
        comment.add("  \"biome_temp op value\" or \"biome_temp (!)freezing\":");
        comment.add("    Biome's temperature parameter. For reference, freezing is < 0.15 and hot is generally considered > 0.95.");
        comment.add("  \"temp op value\" or \"temp (!)freezing\":");
        comment.add("    Height-adjusted temperature. For reference, freezing is < 0.15 and hot is generally considered > 0.95.");
        comment.add("  \"biome_category (!)category\":");
        comment.add("    Valid category values: " + TomlHelper.literalList((Object[])BiomeCategory.values()));
        comment.add("  \"biome (!)namespace:biome_name\":");
        comment.add("    The biome. See the wiki for vanilla biome names (resource locations) [https://minecraft.fandom.com/wiki/Biome#Biome_IDs].");
        comment.add("  \"structure (!)namespace:structure_name\":");
        comment.add("    The structure. See the wiki for vanilla structure names [https://minecraft.fandom.com/wiki/Generated_structures#Locating].");
        comment.add("  \"y op value\":");
        comment.add("    The y-value. For reference, sea level is normally 63 and lava level is normally 10.");
        comment.add("  \"y_from_sea op value\":");
        comment.add("    The y-value from sea level. Expect the only air <= 0 to be in caves/ravines (which may still have direct view of the sky).");
        comment.add("  \"position (!)state\":");
        comment.add("    Valid state values: " + TomlHelper.literalList((Object[])PositionEnvironment.Value.values()));
        comment.add("    Miscellaneous conditions that generally do what you expect. For reference, 'near' a village is ~3 chunks, and redstone checks weak power.");
        comment.add("  \"difficulty op value\":");
        comment.add("    The regional difficulty (0 to 6.75). This is based on many factors such as difficulty setting, moon brightness, chunk inhabited time, and world time.");
        comment.add("    For reference, this scales up to the max after 63 days in the world and 150 days in a particular chunk, and peaks during full moons.");
        comment.add("    On Peaceful this is always 0, on Easy this is 0.75 to 1.5, on Normal this is 1.5 to 4.0, and on Hard this is 2.25 to 6.75.");
        comment.add("  \"special_difficulty op value\":");
        comment.add("    The 'special multiplier' for regional difficulty (0 to 1). For reference, this is 0 when difficulty <= 2 and 1 when difficulty >= 4.");
        comment.add("    This is always 0 in Easy and below. In Normal, it maxes at absolute peak regional difficulty. In Hard, it starts at 0.125 and maxes out in ~50 days.");
        comment.add("  \"weather (!)type\":");
        comment.add("    Valid type values: " + TomlHelper.literalList((Object[])WeatherEnvironment.Value.values()));
        comment.add("  \"moon_brightness op value\":");
        comment.add("    The moon brightness (0 to 1). New moon has 0 brightness, full moon has 1 brightness. Intermediate phases are 0.25, 0.5, or 0.75.");
        comment.add("  \"moon_phase (!)phase\":");
        comment.add("    Valid phase values: " + TomlHelper.literalList((Object[])MoonPhaseEnvironment.Value.values()));
        comment.add("  \"day_time (!)time\":");
        comment.add("    Valid time values: " + TomlHelper.literalList((Object[])DayTimeEnvironment.Value.values()));
        comment.add("    Note that the transition periods, sunset & sunrise, are considered as part of day & night, respectively.");
        comment.add("  \"time_from_midnight op value\":");
        comment.add("    The absolute time in ticks away from midnight. Value must be 0 to 12000.");
        comment.add("  \"moon_phase (!)phase\":");
        comment.add("    Valid phase values: " + TomlHelper.literalList((Object[])MoonPhaseEnvironment.Value.values()));
        comment.add("    For reference, the first day in a new world is always a full moon.");
        comment.add("  \"world_time op value\":");
        comment.add("    The total time the world has existed, in ticks. For reference, each day cycle is 24000 ticks and each lunar cycle is 192000 ticks.");
        comment.add("  \"chunk_time op value\":");
        comment.add("    The total time the chunk has been loaded, in ticks. For reference, each day cycle is 24000 ticks and each lunar cycle is 192000 ticks.");
        return comment;
    }

    public EnvironmentListField(String key, EnvironmentList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Environment List", this.valueDefault, "[ \"value condition1 state1 & condition2 state2 & ...\", ... ]"));
        comment.add("   Range for Values: " + TomlHelper.fieldRange(((EnvironmentList)this.valueDefault).getMinValue(), ((EnvironmentList)this.valueDefault).getMaxValue()));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        List<String> list = TomlHelper.parseStringList(raw);
        ArrayList<EnvironmentEntry> entryList = new ArrayList<EnvironmentEntry>();
        for (String line : list) {
            entryList.add(this.parseEntry(line));
        }
        this.value = new EnvironmentList(entryList);
    }

    private EnvironmentEntry parseEntry(String line) {
        String[] args = line.split(" ", 2);
        double value = this.parseValue(args[0], line);
        ArrayList<AbstractEnvironment> conditions = new ArrayList<AbstractEnvironment>();
        if (args.length > 1) {
            String[] condArgs;
            for (String condArg : condArgs = args[1].split("&")) {
                conditions.add(this.parseCondition(condArg.trim(), line));
            }
        }
        if (conditions.isEmpty()) {
            SpecialMobs.LOG.warn("No environments defined in entry for {} \"{}\"! Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
        }
        return new EnvironmentEntry(value, conditions);
    }

    private double parseValue(String arg, String line) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            value = 0.0;
        }
        if (value < ((EnvironmentList)this.valueDefault).getMinValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EnvironmentList)this.valueDefault).getMinValue(), (Object)value);
            value = ((EnvironmentList)this.valueDefault).getMinValue();
        } else if (value > ((EnvironmentList)this.valueDefault).getMaxValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EnvironmentList)this.valueDefault).getMaxValue(), (Object)value);
            value = ((EnvironmentList)this.valueDefault).getMaxValue();
        }
        return value;
    }

    private AbstractEnvironment parseCondition(String arg, String line) {
        String[] args = arg.split(" ", 2);
        String value = args.length < 2 ? "" : args[1].trim();
        switch (args[0].toLowerCase(Locale.ROOT)) {
            case "dimension_property": {
                return new DimensionPropertyEnvironment(this, value);
            }
            case "dimension_type": {
                return value.endsWith("*") ? new DimensionTypeGroupEnvironment(this, value) : new DimensionTypeEnvironment(this, value);
            }
            case "terrain_depth": {
                return new TerrainDepthEnvironment(this, value);
            }
            case "terrain_scale": {
                return new TerrainScaleEnvironment(this, value);
            }
            case "rainfall": {
                return new RainfallEnvironment(this, value);
            }
            case "biome_temp": {
                return new BiomeTemperatureEnvironment(this, value);
            }
            case "temp": {
                return new TemperatureEnvironment(this, value);
            }
            case "biome_category": {
                return new BiomeCategoryEnvironment(this, value);
            }
            case "biome": {
                return value.endsWith("*") ? new BiomeGroupEnvironment(this, value) : new BiomeEnvironment(this, value);
            }
            case "structure": {
                return value.endsWith("*") ? new StructureGroupEnvironment(this, value) : new StructureEnvironment(this, value);
            }
            case "y": {
                return new YEnvironment(this, value);
            }
            case "y_from_sea": {
                return new YFromSeaEnvironment(this, value);
            }
            case "position": {
                return new PositionEnvironment(this, value);
            }
            case "difficulty": {
                return new DifficultyEnvironment(this, value);
            }
            case "special_difficulty": {
                return new SpecialDifficultyEnvironment(this, value);
            }
            case "weather": {
                return new WeatherEnvironment(this, value);
            }
            case "moon_brightness": {
                return new MoonBrightnessEnvironment(this, value);
            }
            case "moon_phase": {
                return new MoonPhaseEnvironment(this, value);
            }
            case "day_time": {
                return new DayTimeEnvironment(this, value);
            }
            case "time_from_midnight": {
                return new TimeFromMidnightEnvironment(this, value);
            }
            case "world_time": {
                return new WorldTimeEnvironment(this, value);
            }
            case "chunk_time": {
                return new ChunkTimeEnvironment(this, value);
            }
        }
        String[] environmentNames = new String[]{ENV_DIMENSION_PROPERTY, ENV_DIMENSION_TYPE, ENV_TERRAIN_DEPTH, ENV_TERRAIN_SCALE, ENV_RAINFALL, ENV_BIOME_TEMPERATURE, ENV_TEMPERATURE, ENV_BIOME_CATEGORY, ENV_BIOME, ENV_STRUCTURE, ENV_Y, ENV_Y_FROM_SEA, ENV_POSITION, ENV_DIFFICULTY, ENV_SPECIAL_DIFFICULTY, ENV_WEATHER, ENV_MOON_BRIGHTNESS, ENV_MOON_PHASE, ENV_DAY_TIME, ENV_TIME_FROM_MIDNIGHT, ENV_WORLD_TIME, ENV_CHUNK_TIME};
        YEnvironment fallback = new YEnvironment(ComparisonOperator.LESS_THAN, 0);
        SpecialMobs.LOG.warn("Invalid environment '{}' for {} \"{}\"! Falling back to \"{}\". Environment name must be in the set [ {} ]. Invalid environment: {}", (Object)args[0], this.getClass(), (Object)this.getKey(), (Object)fallback, (Object)TomlHelper.literalList(environmentNames), (Object)line);
        return fallback;
    }

    public double getOrElse(World world, @Nullable BlockPos pos, DoubleField defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, pos, defaultValue);
    }

    public double getOrElse(World world, @Nullable BlockPos pos, double defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, pos, defaultValue);
    }

    @Nullable
    public Double get(World world, @Nullable BlockPos pos) {
        return ((EnvironmentList)this.get()).get(world, pos);
    }
}

