/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.List;
import javax.annotation.Nullable;

public class EnumField<T extends Enum<T>>
extends GenericField<T> {
    private final T[] valuesValid;

    public EnumField(String key, T defaultValue, String ... description) {
        this(key, (Enum)defaultValue, (Enum[])defaultValue.getClass().getEnumConstants(), description);
    }

    public EnumField(String key, T defaultValue, T[] validValues, String ... description) {
        super(key, defaultValue, description);
        this.valuesValid = validValues;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoValidValues("Enum", this.valueDefault, this.valuesValid));
    }

    @Override
    public void load(@Nullable Object raw) {
        Enum newValue = null;
        if (raw instanceof String) {
            newValue = (Enum)this.parseValue((String)raw);
        }
        if (newValue == null) {
            if (raw != null) {
                SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            newValue = (Enum)this.valueDefault;
        }
        this.value = newValue;
    }

    @Nullable
    private T parseValue(String name) {
        for (T val : this.valuesValid) {
            if (!((Enum)val).name().equalsIgnoreCase(name)) continue;
            return val;
        }
        return null;
    }
}

