/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.EntityEntry;
import fathertoast.specialmobs.common.config.util.EntityList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class EntityListField
extends GenericField<EntityList> {
    public static final String REG_KEY_DEFAULT = "default";

    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Entity List fields: General format = [ \"namespace:entity_type value1 value2 ...\", ... ]");
        comment.add("  Entity lists are arrays of entity types. Some entity lists specify a number of values linked to each entity type.");
        comment.add("  Entity types are defined by their key in the entity registry, usually following the pattern 'namespace:entity_name'.");
        comment.add("  'default' can be used instead of an entity type registry key to provide default values for all entities.");
        comment.add("  An asterisk '*' can be used to match multiple entity types. For example, 'minecraft:*' will match all vanilla entities.");
        comment.add("  List entries by default match any entity type derived from (i.e. based on) their entity type. For example, '~minecraft:zombie'.");
        comment.add("    There is no steadfast rule about extending, even in vanilla, but the hope is that mod-added mobs will extend their base mob.");
        return comment;
    }

    public EntityListField(String key, EntityList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        String fieldFormat;
        int reqValues = ((EntityList)this.valueDefault).getRequiredValues();
        if (reqValues < 0) {
            fieldFormat = "[ \"namespace:entity_type value1 value2 ...\", ... ]";
        } else {
            StringBuilder format = new StringBuilder("[ \"namespace:entity_type ");
            for (int i = 1; i <= reqValues; ++i) {
                format.append("value");
                if (reqValues > 1) {
                    format.append(i);
                }
                format.append(" ");
            }
            format.deleteCharAt(format.length() - 1).append("\", ... ]");
            fieldFormat = format.toString();
        }
        comment.add(TomlHelper.fieldInfoFormat("Entity List", this.valueDefault, fieldFormat));
        if (reqValues != 0) {
            comment.add("   Range for Values: " + TomlHelper.fieldRange(((EntityList)this.valueDefault).getMinValue(), ((EntityList)this.valueDefault).getMaxValue()));
        }
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        List<String> list = TomlHelper.parseStringList(raw);
        ArrayList<EntityEntry> entryList = new ArrayList<EntityEntry>();
        for (String line : list) {
            entryList.add(this.parseEntry(line));
        }
        this.value = new EntityList(entryList);
    }

    private EntityEntry parseEntry(String line) {
        int i;
        boolean extendable;
        String modifiedLine = line;
        if (line.startsWith("~")) {
            modifiedLine = line.substring(1);
            extendable = false;
        } else {
            extendable = true;
        }
        String[] args = modifiedLine.split(" ");
        ResourceLocation regKey = REG_KEY_DEFAULT.equalsIgnoreCase(args[0].trim()) ? null : new ResourceLocation(args[0].trim());
        ArrayList<Double> valuesList = new ArrayList<Double>();
        int reqValues = ((EntityList)this.valueDefault).getRequiredValues();
        int actualValues = args.length - 1;
        if (reqValues < 0) {
            if (actualValues < 1) {
                SpecialMobs.LOG.warn("Entry has too few values for {} \"{}\"! Expected at least one value. Replacing missing value with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
                valuesList.add(0.0);
            } else {
                for (i = 1; i < args.length; ++i) {
                    valuesList.add(this.parseValue(args[i], line));
                }
            }
        } else {
            if (reqValues > actualValues) {
                SpecialMobs.LOG.warn("Entry has too few values for {} \"{}\"! Expected {} values, but detected {}. Replacing missing values with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            } else if (reqValues < actualValues) {
                SpecialMobs.LOG.warn("Entry has too many values for {} \"{}\"! Expected {} values, but detected {}. Deleting additional values. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            }
            for (i = 1; i < reqValues + 1; ++i) {
                if (i < args.length) {
                    valuesList.add(this.parseValue(args[i], line));
                    continue;
                }
                valuesList.add(0.0);
            }
        }
        double[] values = new double[valuesList.size()];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = (Double)valuesList.get(i2);
        }
        return new EntityEntry(this, regKey, extendable, values);
    }

    private double parseValue(String arg, String line) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            value = 0.0;
        }
        if (value < ((EntityList)this.valueDefault).getMinValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EntityList)this.valueDefault).getMinValue(), (Object)value);
            value = ((EntityList)this.valueDefault).getMinValue();
        } else if (value > ((EntityList)this.valueDefault).getMaxValue()) {
            SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EntityList)this.valueDefault).getMaxValue(), (Object)value);
            value = ((EntityList)this.valueDefault).getMaxValue();
        }
        return value;
    }

    public boolean contains(@Nullable Entity entity) {
        return ((EntityList)this.get()).contains(entity);
    }

    @Nullable
    public double[] getValues(@Nullable Entity entity) {
        return ((EntityList)this.get()).getValues(entity);
    }

    public double getValue(@Nullable Entity entity) {
        return ((EntityList)this.get()).getValue(entity);
    }

    public boolean rollChance(@Nullable LivingEntity entity) {
        return ((EntityList)this.get()).rollChance(entity);
    }

    public static class Combined {
        private final EntityListField WHITELIST;
        private final EntityListField BLACKLIST;

        public Combined(EntityListField whitelist, EntityListField blacklist) {
            this.WHITELIST = whitelist;
            this.BLACKLIST = blacklist;
            if (((EntityList)blacklist.valueDefault).getRequiredValues() != 0) {
                throw new IllegalArgumentException("Blacklists cannot have values! See: " + blacklist.getKey());
            }
        }

        public boolean contains(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) && this.WHITELIST.contains(entity);
        }

        @Nullable
        public double[] getValues(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) ? this.WHITELIST.getValues(entity) : null;
        }

        public double getValue(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) ? this.WHITELIST.getValue(entity) : 0.0;
        }

        public boolean rollChance(@Nullable LivingEntity entity) {
            return entity != null && !this.BLACKLIST.contains((Entity)entity) && this.WHITELIST.rollChance(entity);
        }
    }
}

