/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.field.EnvironmentListField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DoubleField
extends AbstractConfigField {
    private final double valueDefault;
    private final double valueMin;
    private final double valueMax;
    private double value;

    public DoubleField(String key, double defaultValue, Range range, String ... description) {
        this(key, defaultValue, range.MIN, range.MAX, description);
    }

    public DoubleField(String key, double defaultValue, double min, double max, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
        this.valueMin = min;
        this.valueMax = max;
    }

    public double get() {
        return this.value;
    }

    public boolean rollChance(Random random) {
        return random.nextDouble() < this.value;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoRange(this.valueDefault, this.valueMin, this.valueMax));
    }

    @Override
    public void load(@Nullable Object raw) {
        double newValue;
        if (raw instanceof Number) {
            double rawValue = ((Number)raw).doubleValue();
            if (rawValue < this.valueMin) {
                SpecialMobs.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMin, raw);
                newValue = this.valueMin;
            } else if (rawValue > this.valueMax) {
                SpecialMobs.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMax, raw);
                newValue = this.valueMax;
            } else {
                newValue = rawValue;
            }
        } else {
            if (raw instanceof String) {
                SpecialMobs.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
                this.load(TomlHelper.parseRaw((String)raw));
                return;
            }
            if (raw != null) {
                SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            newValue = this.valueDefault;
        }
        this.value = newValue;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }

    public static class EnvironmentSensitiveWeightedList<T> {
        private final List<Entry<T>> UNDERLYING_LIST;

        public EnvironmentSensitiveWeightedList(T[] values, DoubleField[] baseWeights, EnvironmentListField[] weightExceptions) {
            if (values.length != baseWeights.length || values.length != weightExceptions.length) {
                throw new IllegalArgumentException("All arrays must be equal length!");
            }
            ArrayList<Entry<T>> list = new ArrayList<Entry<T>>();
            for (int i = 0; i < values.length; ++i) {
                list.add(new Entry<T>(values[i], new EnvironmentSensitive(baseWeights[i], weightExceptions[i])));
                if (!(baseWeights[i].valueMin < 0.0) && !(((EnvironmentList)weightExceptions[i].valueDefault).getMinValue() < 0.0)) continue;
                throw new IllegalArgumentException("Weight is not allowed to be negative! See " + baseWeights[i].getKey() + " and/or " + weightExceptions[i].getKey());
            }
            list.trimToSize();
            this.UNDERLYING_LIST = Collections.unmodifiableList(list);
        }

        @Nullable
        public T next(Random random, World world, @Nullable BlockPos pos) {
            return this.next(random, world, pos, null);
        }

        @Nullable
        public T next(Random random, World world, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            int i;
            double[] weights = new double[this.UNDERLYING_LIST.size()];
            double targetWeight = 0.0;
            for (i = 0; i < weights.length; ++i) {
                Entry<T> entry = this.UNDERLYING_LIST.get(i);
                if (selector != null && !selector.test(entry.VALUE)) continue;
                weights[i] = entry.WEIGHT.get(world, pos);
                targetWeight += weights[i];
            }
            if (targetWeight <= 0.0) {
                return null;
            }
            targetWeight *= random.nextDouble();
            for (i = 0; i < weights.length; ++i) {
                if (!((targetWeight -= weights[i]) < 0.0)) continue;
                return this.UNDERLYING_LIST.get((int)i).VALUE;
            }
            SpecialMobs.LOG.error("Environment-sensitive weight list was unable to return a value when it should have! This is probably due to error in floating point calculations, perhaps try changing the scale of weights.");
            return null;
        }

        private static class Entry<T> {
            final T VALUE;
            final EnvironmentSensitive WEIGHT;

            Entry(T value, EnvironmentSensitive weight) {
                this.VALUE = value;
                this.WEIGHT = weight;
            }
        }
    }

    public static class EnvironmentSensitive {
        private final DoubleField BASE;
        private final EnvironmentListField EXCEPTIONS;

        public EnvironmentSensitive(DoubleField base, EnvironmentListField exceptions) {
            this.BASE = base;
            this.EXCEPTIONS = exceptions;
        }

        public double get(World world, @Nullable BlockPos pos) {
            return this.EXCEPTIONS.getOrElse(world, pos, this.BASE);
        }

        public boolean rollChance(Random random, World world, @Nullable BlockPos pos) {
            return random.nextDouble() < this.get(world, pos);
        }
    }

    public static class RandomRange {
        private final DoubleField MINIMUM;
        private final DoubleField MAXIMUM;

        public RandomRange(DoubleField minimum, DoubleField maximum) {
            this.MINIMUM = minimum;
            this.MAXIMUM = maximum;
            if (minimum.valueDefault > maximum.valueDefault) {
                throw new IllegalArgumentException(String.format("Random range has inverted default values! (%s > %s) See: (%s, %s)", minimum.valueDefault, maximum.valueDefault, minimum.getKey(), maximum.getKey()));
            }
        }

        public double getMin() {
            return this.MINIMUM.get();
        }

        public double getMax() {
            return this.MAXIMUM.get();
        }

        public double next(Random random) {
            double delta = this.getMax() - this.getMin();
            if (delta > 1.0E-4) {
                return this.getMin() + random.nextDouble() * delta;
            }
            if (delta < 0.0) {
                SpecialMobs.LOG.warn("Value for range \"({},{})\" is invalid ({} > {})! Ignoring maximum value.", (Object)this.MINIMUM.getKey(), (Object)this.MAXIMUM.getKey(), (Object)this.getMin(), (Object)this.getMax());
            }
            return this.getMin();
        }
    }

    public static enum Range {
        ANY(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY),
        NON_NEGATIVE(0.0, Double.POSITIVE_INFINITY),
        PERCENT(0.0, 1.0),
        SIGNED_PERCENT(-1.0, 1.0),
        DROP_CHANCE(-1.0, 2.0);

        public final double MIN;
        public final double MAX;

        private Range(double min, double max) {
            this.MIN = min;
            this.MAX = max;
        }
    }
}

