/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.AbstractConfigField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.List;
import javax.annotation.Nullable;

public class BooleanField
extends AbstractConfigField {
    private final boolean valueDefault;
    private boolean value;

    public BooleanField(String key, boolean defaultValue, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoValidValues("Boolean", this.valueDefault, true, false));
    }

    @Override
    public void load(@Nullable Object raw) {
        boolean newValue;
        if (raw instanceof Boolean) {
            newValue = (Boolean)raw;
        } else if (raw instanceof Number) {
            double rawValue = ((Number)raw).doubleValue();
            SpecialMobs.LOG.warn("Value for {} \"{}\" is numerical! Converting value. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            newValue = rawValue != 0.0;
        } else {
            if (raw instanceof String) {
                SpecialMobs.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
                this.load(TomlHelper.parseRaw((String)raw));
                return;
            }
            if (raw != null) {
                SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            newValue = this.valueDefault;
        }
        this.value = newValue;
    }

    @Override
    public Object getRaw() {
        return this.value;
    }
}

