/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.BlockList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;

public class BlockListField
extends GenericField<BlockList> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Block List fields: General format = [ \"namespace:block_name[property1=value1,...]\", ... ]");
        comment.add("  Block lists are arrays of blocks and partial block states.");
        comment.add("  Blocks are defined by their key in the block registry, usually following the pattern 'namespace:block_name'.");
        comment.add("  An asterisk '*' can be used to match multiple blocks. For example, 'minecraft:*' will match all vanilla blocks.");
        comment.add("  List entries by default match any block state. The block states to match can be narrowed down by specifying properties.");
        comment.add("    The syntax for block state properties is the same as for commands. Any properties not specified will match any value.");
        comment.add("    For example, 'minecraft:beehive[honey_level=5]' will match any full beehives, regardless of the direction they face.");
        return comment;
    }

    public BlockListField(String key, BlockList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Block List", this.valueDefault, "[ \"namespace:block_name[properties]\", ... ]"));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        this.value = new BlockList(this, TomlHelper.parseStringList(raw));
    }

    public boolean isEmpty() {
        return ((BlockList)this.get()).isEmpty();
    }

    public boolean matches(BlockState blockState) {
        return ((BlockList)this.get()).matches(blockState);
    }

    public static class Combined {
        public final BlockListField WHITELIST;
        public final BlockListField BLACKLIST;

        public Combined(BlockListField whitelist, BlockListField blacklist) {
            this.WHITELIST = whitelist;
            this.BLACKLIST = blacklist;
        }

        public boolean isEmpty() {
            return ((BlockList)this.WHITELIST.get()).isEmpty();
        }

        public boolean matches(BlockState blockState) {
            return !((BlockList)this.BLACKLIST.get()).matches(blockState) && ((BlockList)this.WHITELIST.get()).matches(blockState);
        }
    }
}

