/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.field.GenericField;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.AttributeEntry;
import fathertoast.specialmobs.common.config.util.AttributeList;
import fathertoast.specialmobs.common.config.util.ConfigDrivenAttributeModifierMap;
import fathertoast.specialmobs.common.core.SpecialMobs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AttributeListField
extends GenericField<AttributeList> {
    public ConfigDrivenAttributeModifierMap linkedAttributeMap;

    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Attribute List fields: General format = [ \"namespace:attribute_name operation value\", ... ]");
        comment.add("  Attribute lists are arrays of base attribute changes. Attributes are defined by their key in the attribute registry,");
        comment.add("    usually following the pattern 'namespace:attribute_name'.");
        comment.add("  The operations that can be performed are +, -, and *. The + and - operators change the attribute by adding the value to it");
        comment.add("    (or subtracting the value from it). The * operator changes the attribute by multiplying it by the value.");
        comment.add("  Each entry in the attribute list is applied in the exact order listed.");
        comment.add("  As an example, the entry \"minecraft:generic.max_health + 10.0\" will increase a mob's max health by 10. By convention, never");
        comment.add("    use the + or - operators for movement speed (minecraft:generic.movement_speed).");
        return comment;
    }

    public AttributeListField(String key, AttributeList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Attribute List", this.valueDefault, "[ \"namespace:attribute_name operation value\", ... ]"));
        comment.add("   Range for Values: " + TomlHelper.fieldRange(DoubleField.Range.ANY.MIN, DoubleField.Range.ANY.MAX));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        List<String> list = TomlHelper.parseStringList(raw);
        ArrayList<AttributeEntry> entryList = new ArrayList<AttributeEntry>();
        for (String line : list) {
            entryList.add(this.parseEntry(line));
        }
        this.value = new AttributeList(entryList);
        if (this.linkedAttributeMap != null) {
            this.linkedAttributeMap.invalidate();
        }
    }

    private AttributeEntry parseEntry(String line) {
        double value;
        int identityValue;
        int operator;
        String[] args = line.split(" ", 4);
        if (args.length > 3) {
            SpecialMobs.LOG.warn("Entry has for {} \"{}\" is too long! Deleting excess. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
        }
        ResourceLocation regKey = new ResourceLocation(args[0].trim());
        boolean OP_MULTIPLY = false;
        boolean OP_ADD = true;
        int OP_SUBTRACT = -1;
        if (args.length < 2) {
            SpecialMobs.LOG.warn("Entry has no operator for {} \"{}\"! Replacing missing operator with +. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            operator = 1;
        } else {
            switch (args[1]) {
                case "*": {
                    operator = 0;
                    break;
                }
                case "+": {
                    operator = 1;
                    break;
                }
                case "-": {
                    operator = -1;
                    break;
                }
                default: {
                    operator = 1;
                    SpecialMobs.LOG.warn("Entry has invalid operator {} for {} \"{}\"! Replacing operator with +. Invalid entry: {}", (Object)args[1], this.getClass(), (Object)this.getKey(), (Object)line);
                }
            }
        }
        int n = identityValue = operator == 0 ? 1 : 0;
        if (args.length < 3) {
            SpecialMobs.LOG.warn("Entry has no value for {} \"{}\"! Replacing missing value with {}. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)identityValue, (Object)line);
            value = identityValue;
        } else {
            value = this.parseValue(args[2], line, identityValue);
        }
        return operator == 0 ? new AttributeEntry(this, regKey, true, value) : new AttributeEntry(this, regKey, false, value * (double)operator);
    }

    private double parseValue(String arg, String line, int identity) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            SpecialMobs.LOG.warn("Invalid value for {} \"{}\"! Falling back to {}. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)identity, (Object)line);
            value = identity;
        }
        return value;
    }

    public void apply(AttributeModifierMap.MutableAttribute builder) {
        ((AttributeList)this.get()).apply(builder);
    }

    public void apply(LivingEntity entity) {
        ((AttributeList)this.get()).apply(entity);
    }
}

