/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.field;

import com.electronwill.nightconfig.core.io.CharacterOutput;
import fathertoast.specialmobs.common.config.file.ToastTomlWriter;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.IStringArray;
import fathertoast.specialmobs.common.config.util.RestartNote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractConfigField {
    public static String loadingCategory;
    private final String KEY;
    private List<String> COMMENT;

    protected AbstractConfigField(String key, String ... description) {
        this(loadingCategory + key, description == null ? null : TomlHelper.newComment(description));
    }

    AbstractConfigField(String key, @Nullable List<String> comment) {
        this.KEY = key;
        this.COMMENT = comment;
    }

    public final String getKey() {
        return this.KEY;
    }

    @Nullable
    public final List<String> getComment() {
        return this.COMMENT;
    }

    public final void finalizeComment(@Nullable RestartNote restartNote) {
        if (this.COMMENT == null) {
            return;
        }
        RestartNote.appendComment(this.COMMENT, restartNote);
        this.appendFieldInfo(this.COMMENT);
        ((ArrayList)this.COMMENT).trimToSize();
        this.COMMENT = Collections.unmodifiableList(this.COMMENT);
    }

    public abstract void appendFieldInfo(List<String> var1);

    public abstract void load(@Nullable Object var1);

    public abstract Object getRaw();

    public void writeValue(ToastTomlWriter writer, CharacterOutput output) {
        Object raw = this.getRaw();
        if (raw instanceof IStringArray) {
            writer.writeStringArray(((IStringArray)raw).toStringList(), output);
        } else {
            writer.writeLine(TomlHelper.toLiteral(raw), output);
        }
    }
}

