/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.family;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.field.BooleanField;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.field.EnvironmentListField;
import fathertoast.specialmobs.common.config.file.ToastConfigSpec;
import fathertoast.specialmobs.common.config.file.TomlHelper;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import java.io.File;
import java.util.ArrayList;

public class FamilyConfig
extends Config.AbstractConfig {
    protected static final double VARIANT_CHANCE_LOW = 0.2;
    protected static final double VARIANT_CHANCE_HIGH = 0.33;
    public final General GENERAL;

    public static File dir(MobFamily<?, ?> family) {
        return new File(Config.CONFIG_DIR, ConfigUtil.noSpaces(family.configName));
    }

    protected static String fileName(MobFamily<?, ?> family) {
        return "_family_of_" + ConfigUtil.noSpaces(family.configName);
    }

    public static FamilyConfig newLessSpecial(MobFamily<?, ?> family) {
        return new FamilyConfig(family, 0.2);
    }

    public static FamilyConfig newMoreSpecial(MobFamily<?, ?> family) {
        return new FamilyConfig(family, 0.33);
    }

    public FamilyConfig(MobFamily<?, ?> family) {
        this(family, 0.25);
    }

    public FamilyConfig(MobFamily<?, ?> family, double variantChance) {
        super(FamilyConfig.dir(family), FamilyConfig.fileName(family), "This config contains options that apply to the family of " + family.configName + " as a whole;", "that is, the vanilla replacement and all special variants.");
        this.GENERAL = new General(this.SPEC, family, variantChance);
    }

    public static class General
    extends Config.AbstractCategory {
        public final BooleanField vanillaReplacement;
        public final DoubleField familyRandomScaling;
        public final DoubleField.EnvironmentSensitive specialVariantChance;
        public final DoubleField.EnvironmentSensitiveWeightedList<MobFamily.Species<?>> specialVariantList;

        General(ToastConfigSpec parent, MobFamily<?, ?> family, double variantChance) {
            super(parent, "general", "Options standard to all mob families (that is, not specific to any particular mob family).");
            int i;
            this.vanillaReplacement = this.SPEC.define(new BooleanField("vanilla_replacement", true, "Whether this mob family replaces vanilla " + family.configName + " with its vanilla replacement species.", "The \"master_vanilla_replacement\" setting in the mod's main config must also be true for this to work."));
            this.SPEC.newLine();
            this.familyRandomScaling = this.SPEC.define(new DoubleField("family_random_scaling", -1.0, DoubleField.Range.SIGNED_PERCENT, "When greater than 0, " + family.configName + " will have a random render scale applied. This is a visual effect only.", "If this is set to a non-negative value, it overrides the value set for \"master_random_scaling\", though", "species configs can override this value."));
            this.SPEC.newLine();
            this.specialVariantChance = new DoubleField.EnvironmentSensitive(this.SPEC.define(new DoubleField("special_variant_chance.base", variantChance, DoubleField.Range.PERCENT, "The chance for " + family.configName + " to spawn as special variants.")), this.SPEC.define(new EnvironmentListField("special_variant_chance.exceptions", new EnvironmentList(EnvironmentEntry.builder((float)variantChance * 0.5f).beforeDays(5).build(), EnvironmentEntry.builder((float)variantChance * 2.0f).atMaxMoonLight().aboveDifficulty(0.5f).build(), EnvironmentEntry.builder((float)variantChance * 1.5f).atMaxMoonLight().build(), EnvironmentEntry.builder((float)variantChance * 1.5f).aboveDifficulty(0.5f).build()).setRange(DoubleField.Range.PERCENT), "The chance for " + family.configName + " to spawn as special variants when specific environmental conditions are met.")));
            this.SPEC.newLine();
            DoubleField[] baseWeights = new DoubleField[family.variants.length];
            EnvironmentListField[] weightExceptions = new EnvironmentListField[family.variants.length];
            ArrayList<String> comment = TomlHelper.newComment("The weight of each " + ConfigUtil.camelCaseToLowerSpace(family.name) + " species to be chosen as the replacement when", family.configName + " spawn as special variants. Higher weight is more common.");
            comment.add(TomlHelper.multiFieldInfo(DoubleField.Range.NON_NEGATIVE));
            this.SPEC.comment(comment);
            for (i = 0; i < family.variants.length; ++i) {
                baseWeights[i] = this.SPEC.define(new DoubleField("weight." + ConfigUtil.camelCaseToLowerUnderscore(family.variants[i].specialVariantName) + ".base", family.variants[i].bestiaryInfo.defaultWeight.value, DoubleField.Range.NON_NEGATIVE, (String[])null));
            }
            this.SPEC.newLine();
            comment = TomlHelper.newComment("The weight of each " + ConfigUtil.camelCaseToLowerSpace(family.name) + " species to be chosen as the replacement when", family.configName + " spawn as special variants when specific environmental conditions are met. Higher weight is more common.");
            comment.add(TomlHelper.multiFieldInfo(DoubleField.Range.NON_NEGATIVE));
            this.SPEC.comment(comment);
            for (i = 0; i < family.variants.length; ++i) {
                weightExceptions[i] = this.SPEC.define(new EnvironmentListField("weight." + ConfigUtil.camelCaseToLowerUnderscore(family.variants[i].specialVariantName) + ".exceptions", family.variants[i].bestiaryInfo.theme.value, (String[])null));
            }
            this.specialVariantList = new DoubleField.EnvironmentSensitiveWeightedList(family.variants, baseWeights, weightExceptions);
        }
    }
}

