/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.block;

import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.util.References;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class MeltingIceBlock
extends IceBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final BooleanProperty HAS_WATER = BooleanProperty.func_177716_a((String)"has_water");

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Melting Ice", "", "", "", "", "", "");
    }

    public static BlockState getState(World world, BlockPos pos) {
        BlockState currentBlock = world.func_180495_p(pos);
        return (BlockState)((Block)SMBlocks.MELTING_ICE.get()).func_176223_P().func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(currentBlock.func_203425_a(Blocks.field_185778_de) || currentBlock.func_177230_c() == Blocks.field_150355_j && (Integer)currentBlock.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0));
    }

    public static void scheduleFirstTick(World world, BlockPos pos, Random random) {
        world.func_205220_G_().func_205360_a(pos, (Object)SMBlocks.MELTING_ICE.get(), MathHelper.func_76136_a((Random)random, (int)60, (int)120));
    }

    private void scheduleTick(World world, BlockPos pos, Random random) {
        int darkness = 15 - MeltingIceBlock.getLight(world, pos);
        int solidNeighbors = 0;
        BlockPos.Mutable neighborPos = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!world.func_180495_p((BlockPos)neighborPos.func_239622_a_((Vector3i)pos, direction)).func_185904_a().func_76220_a()) continue;
            ++solidNeighbors;
        }
        int delay = 5 + darkness + 10 * solidNeighbors;
        world.func_205220_G_().func_205360_a(pos, (Object)this, MathHelper.func_76136_a((Random)random, (int)delay, (int)(delay << 1)));
    }

    private static int getLight(World world, BlockPos pos) {
        int highestLight = 0;
        BlockPos.Mutable neighborPos = new BlockPos.Mutable();
        for (Direction direction : Direction.values()) {
            int neighborLight = world.func_226658_a_(LightType.BLOCK, (BlockPos)neighborPos.func_239622_a_((Vector3i)pos, direction));
            if (neighborLight > 14) {
                return 15;
            }
            if (neighborLight <= highestLight) continue;
            highestLight = neighborLight;
        }
        return highestLight;
    }

    public MeltingIceBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151588_w).func_200947_a(SoundType.field_185853_f).func_226896_b_().func_200944_c().func_200941_a(0.98f).func_200943_b(0.5f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)HAS_WATER, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE}).func_206894_a(new Property[]{HAS_WATER});
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity tileEntity, ItemStack tool) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        MeltingIceBlock.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tileEntity, (Entity)player, (ItemStack)tool);
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) == 0) {
            this.func_196454_d(state, world, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        this.func_225534_a_(state, world, pos, random);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (this.canMelt((World)world, pos)) {
            if (this.slightlyMelt(state, (World)world, pos, random)) {
                BlockPos.Mutable neighborPos = new BlockPos.Mutable();
                this.trySlightlyMelt((World)world, (BlockPos)neighborPos.func_239622_a_((Vector3i)pos, Direction.DOWN), random);
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.trySlightlyMelt((World)world, (BlockPos)neighborPos.func_239622_a_((Vector3i)pos, direction), random);
                }
            }
        } else {
            this.scheduleTick((World)world, pos, random);
        }
    }

    private boolean canMelt(World world, BlockPos pos) {
        if (MeltingIceBlock.getLight(world, pos) > 13) {
            return true;
        }
        BlockPos.Mutable neighborPos = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (world.func_180495_p((BlockPos)neighborPos.func_239622_a_((Vector3i)pos, direction)).func_203425_a((Block)this)) continue;
            return !world.func_180495_p((BlockPos)neighborPos.func_239622_a_((Vector3i)pos, Direction.UP)).func_203425_a((Block)this) || world.func_180495_p((BlockPos)neighborPos.func_239622_a_((Vector3i)pos, Direction.DOWN)).func_196958_f();
        }
        return false;
    }

    private void trySlightlyMelt(World world, BlockPos pos, Random random) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_203425_a((Block)this) && this.canMelt(world, pos)) {
            this.slightlyMelt(state, world, pos, random);
        }
    }

    private boolean slightlyMelt(BlockState state, World world, BlockPos pos, Random random) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 3) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            this.scheduleTick(world, pos, random);
            return false;
        }
        this.func_196454_d(state, world, pos);
        return true;
    }

    protected void func_196454_d(BlockState state, World world, BlockPos pos) {
        if (world.func_230315_m_().func_236040_e_() || !((Boolean)state.func_177229_b((Property)HAS_WATER)).booleanValue()) {
            world.func_217377_a(pos, false);
        } else {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            world.func_190524_a(pos, Blocks.field_150355_j, pos);
        }
    }
}

