/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.bestiary;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.config.family.CreeperFamilyConfig;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.config.family.GhastFamilyConfig;
import fathertoast.specialmobs.common.config.family.SilverfishFamilyConfig;
import fathertoast.specialmobs.common.config.family.SkeletonFamilyConfig;
import fathertoast.specialmobs.common.config.family.SlimeFamilyConfig;
import fathertoast.specialmobs.common.config.family.WitchFamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.util.AnnotationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.RegistryObject;

public class MobFamily<T extends LivingEntity, V extends FamilyConfig> {
    private static final ArrayList<MobFamily<?, ?>> FAMILY_LIST = new ArrayList();
    private static final List<Species<?>> SPECIES_LIST;
    private static final Map<EntityType<?>, MobFamily<?, ?>> TYPE_TO_FAMILY_MAP;
    public static final MobFamily<CreeperEntity, CreeperFamilyConfig> CREEPER;
    public static final MobFamily<ZombieEntity, FamilyConfig> ZOMBIE;
    public static final MobFamily<DrownedEntity, FamilyConfig> DROWNED;
    public static final MobFamily<ZombifiedPiglinEntity, FamilyConfig> ZOMBIFIED_PIGLIN;
    public static final MobFamily<AbstractSkeletonEntity, SkeletonFamilyConfig> SKELETON;
    public static final MobFamily<AbstractSkeletonEntity, SkeletonFamilyConfig> WITHER_SKELETON;
    public static final MobFamily<SlimeEntity, SlimeFamilyConfig> SLIME;
    public static final MobFamily<MagmaCubeEntity, FamilyConfig> MAGMA_CUBE;
    public static final MobFamily<SpiderEntity, FamilyConfig> SPIDER;
    public static final MobFamily<CaveSpiderEntity, FamilyConfig> CAVE_SPIDER;
    public static final MobFamily<SilverfishEntity, SilverfishFamilyConfig> SILVERFISH;
    public static final MobFamily<EndermanEntity, FamilyConfig> ENDERMAN;
    public static final MobFamily<WitchEntity, WitchFamilyConfig> WITCH;
    public static final MobFamily<GhastEntity, GhastFamilyConfig> GHAST;
    public static final MobFamily<BlazeEntity, FamilyConfig> BLAZE;
    public final String name;
    public final String configName;
    public final int eggBaseColor;
    public final EntityType<?>[] replaceableTypes;
    public final Species<? extends T> vanillaReplacement;
    public final Species<? extends T>[] variants;
    public final V config;
    private Boolean hasAnyGiants;

    public static void initBestiary() {
    }

    public static List<MobFamily<?, ?>> getAll() {
        return Collections.unmodifiableList(FAMILY_LIST);
    }

    public static List<Species<?>> getAllSpecies() {
        return SPECIES_LIST;
    }

    @Nullable
    public static MobFamily<?, ?> getReplacementFamily(Entity entity) {
        return TYPE_TO_FAMILY_MAP.get(entity.func_200600_R());
    }

    private MobFamily(Function<MobFamily<?, ?>, V> configSupplier, String familyName, String readableName, int eggColor, EntityType<?>[] replaceable, String ... variantNames) {
        this.name = familyName;
        this.configName = readableName.toLowerCase(Locale.ROOT);
        this.eggBaseColor = eggColor;
        this.replaceableTypes = replaceable;
        if (replaceable.length < 1) {
            throw new IllegalArgumentException(familyName + " family must have at least one replaceable type!");
        }
        String packageRoot = "fathertoast.specialmobs.common.entity." + this.name.toLowerCase();
        this.vanillaReplacement = new Species(this, packageRoot, null);
        this.variants = new Species[variantNames.length];
        for (int i = 0; i < this.variants.length; ++i) {
            this.variants[i] = new Species(this, packageRoot, variantNames[i]);
        }
        this.config = (FamilyConfig)configSupplier.apply(this);
        ((FamilyConfig)this.config).SPEC.initialize();
        FAMILY_LIST.add(this);
    }

    public Species<? extends T> nextVariant(World world, @Nullable BlockPos pos, @Nullable Predicate<Species<?>> selector) {
        return this.nextVariant(world, pos, selector, this.vanillaReplacement);
    }

    public Species<? extends T> nextVariant(World world, @Nullable BlockPos pos, @Nullable Predicate<Species<?>> selector, Species<? extends T> fallback) {
        Species<?> species = ((FamilyConfig)this.config).GENERAL.specialVariantList.next(world.field_73012_v, world, pos, selector);
        return species == null ? fallback : species;
    }

    public boolean hasAnyGiants() {
        if (this.hasAnyGiants == null) {
            this.hasAnyGiants = false;
            for (Species<T> species : this.variants) {
                if (species.isNotGiant()) continue;
                this.hasAnyGiants = true;
                break;
            }
        }
        return this.hasAnyGiants;
    }

    static {
        CREEPER = new MobFamily(CreeperFamilyConfig::new, "Creeper", "creepers", 894731, new EntityType[]{EntityType.field_200797_k}, "Dark", "Death", "Dirt", "Doom", "Drowning", "Ender", "Fire", "Gravel", "Jumping", "Lightning", "Mini", "Sand", "Snow", "Skeleton", "Splitting");
        ZOMBIE = new MobFamily(FamilyConfig::newLessSpecial, "Zombie", "zombies", 44975, new EntityType[]{EntityType.field_200725_aD, EntityType.field_200763_C}, "Brute", "Fire", "Fishing", "Frozen", "Giant", "Hungry", "Husk", "MadScientist", "Plague");
        DROWNED = new MobFamily(FamilyConfig::new, "Drowned", "drowned", 9433559, new EntityType[]{EntityType.field_204724_o}, "Abyssal", "Brute", "Fishing", "Frozen", "Giant", "Hungry", "Knight", "Plague");
        ZOMBIFIED_PIGLIN = new MobFamily(FamilyConfig::new, "ZombifiedPiglin", "zombified piglins", 15373203, new EntityType[]{EntityType.field_233592_ba_}, "Brute", "Fishing", "Giant", "Hungry", "Knight", "Plague", "Vampire");
        SKELETON = new MobFamily(SkeletonFamilyConfig::new, "Skeleton", "skeletons", 0xC1C1C1, new EntityType[]{EntityType.field_200741_ag, EntityType.field_200750_ap}, "Brute", "Fire", "Gatling", "Giant", "Knight", "Ninja", "Poison", "Sniper", "Spitfire", "Stray", "Weathered");
        WITHER_SKELETON = new MobFamily(SkeletonFamilyConfig::new, "WitherSkeleton", "wither skeletons", 0x141414, new EntityType[]{EntityType.field_200722_aA}, "Brute", "Gatling", "Giant", "Knight", "Ninja", "Sniper", "Spitfire");
        SLIME = new MobFamily(SlimeFamilyConfig::new, "Slime", "slimes", 5349438, new EntityType[]{EntityType.field_200743_ai}, "Blackberry", "Blueberry", "Caramel", "Frozen", "Grape", "Lemon", "Potion", "Strawberry", "Watermelon");
        MAGMA_CUBE = new MobFamily(FamilyConfig::newMoreSpecial, "MagmaCube", "magma cubes", 0x340000, new EntityType[]{EntityType.field_200771_K}, "Bouncing", "Hardened", "Sticky", "Volatile");
        SPIDER = new MobFamily(FamilyConfig::newMoreSpecial, "Spider", "spiders", 3419431, new EntityType[]{EntityType.field_200748_an}, "Baby", "Desert", "Fire", "Flying", "Giant", "Hungry", "Mother", "Pale", "Poison", "Water", "Web", "Witch");
        CAVE_SPIDER = new MobFamily(FamilyConfig::newMoreSpecial, "CaveSpider", "cave spiders", 803406, new EntityType[]{EntityType.field_200794_h}, "Baby", "Desert", "Fire", "Flying", "Mother", "Pale", "Water", "Web", "Witch");
        SILVERFISH = new MobFamily(SilverfishFamilyConfig::new, "Silverfish", "silverfish", 0x6E6E6E, new EntityType[]{EntityType.field_200740_af}, "Albino", "Blinding", "Desiccated", "Fire", "Fishing", "Flying", "Poison", "Puffer", "Tough");
        ENDERMAN = new MobFamily(FamilyConfig::new, "Enderman", "endermen", 0x161616, new EntityType[]{EntityType.field_200803_q}, "Blinding", "Flame", "Icy", "Lightning", "Mini", "Mirage", "Runic", "Thief");
        WITCH = new MobFamily(WitchFamilyConfig::new, "Witch", "witches", 0x340000, new EntityType[]{EntityType.field_200759_ay}, "Domination", "Shadows", "Undead", "Wilds", "Wind");
        GHAST = new MobFamily(GhastFamilyConfig::new, "Ghast", "ghasts", 0xF9F9F9, new EntityType[]{EntityType.field_200811_y}, "Baby", "CorporealShift", "Fighter", "King", "Queen", "Unholy");
        BLAZE = new MobFamily(FamilyConfig::new, "Blaze", "blazes", 16167425, new EntityType[]{EntityType.field_200792_f}, "Cinder", "Conflagration", "Ember", "Hellfire", "Inferno", "Jolt", "Wildfire");
        FAMILY_LIST.trimToSize();
        HashMap classToFamilyMap = new HashMap();
        ArrayList allSpecies = new ArrayList();
        for (MobFamily<?, ?> family : FAMILY_LIST) {
            for (EntityType<?> replaceable : family.replaceableTypes) {
                classToFamilyMap.put(replaceable, family);
            }
            allSpecies.add(family.vanillaReplacement);
            allSpecies.addAll(Arrays.asList(family.variants));
        }
        allSpecies.trimToSize();
        TYPE_TO_FAMILY_MAP = Collections.unmodifiableMap(classToFamilyMap);
        SPECIES_LIST = Collections.unmodifiableList(allSpecies);
    }

    public static class Species<T extends LivingEntity> {
        private static final Map<EntityType<?>, Species<?>> TYPE_TO_SPECIES_MAP = new HashMap();
        public final MobFamily<? super T, ?> family;
        public final String specialVariantName;
        public final String name;
        public final Class<T> entityClass;
        public final BestiaryInfo bestiaryInfo;
        public final RegistryObject<EntityType<T>> entityType;
        public final RegistryObject<ForgeSpawnEggItem> spawnEgg;
        public final SpeciesConfig config;
        private Boolean isNotGiant;
        private float heightScale = -1.0f;

        @Nullable
        public static Species<?> of(EntityType<?> entityType) {
            return TYPE_TO_SPECIES_MAP.get(entityType);
        }

        private Species(MobFamily<? super T, ?> parentFamily, String packageRoot, @Nullable String variantName) {
            boolean vanillaReplacement = variantName == null;
            this.family = parentFamily;
            this.specialVariantName = variantName;
            this.name = vanillaReplacement ? parentFamily.name : variantName + parentFamily.name;
            this.entityClass = this.findClass(vanillaReplacement ? "%s._Special%sEntity" : "%s.%sEntity", packageRoot);
            EntityType.Builder<T> entityTypeBuilder = this.makeEntityTypeBuilder(parentFamily.replaceableTypes[0]);
            this.bestiaryInfo = AnnotationHelper.getBestiaryInfo(this, BestiaryInfo.of(this, entityTypeBuilder)).build();
            this.entityType = SMEntities.register(this.name.toLowerCase(Locale.ROOT), entityTypeBuilder);
            this.spawnEgg = SMItems.registerSpawnEgg(this.entityType, parentFamily.eggBaseColor, this.bestiaryInfo.eggSpotsColor);
            this.config = AnnotationHelper.createConfig(this);
            this.config.SPEC.initialize();
            AnnotationHelper.injectSpeciesReference(this);
            AnnotationHelper.verifySpeciesSupplier(this);
        }

        private Class<T> findClass(String format, String packageRoot) {
            try {
                return Class.forName(String.format(format, packageRoot, this.name));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("Failed to find entity class for mob species " + this.name, ex);
            }
        }

        private EntityType.Builder<T> makeEntityTypeBuilder(EntityType<?> original) {
            EntityType.IFactory factory = AnnotationHelper.getEntityFactory(this);
            EntityType.Builder clone = EntityType.Builder.func_220322_a(factory, (EntityClassification)original.func_220339_d());
            if (!original.func_200720_b()) {
                clone.func_200705_b();
            }
            if (!original.func_200715_a()) {
                clone.func_200706_c();
            }
            if (original.func_220338_c()) {
                clone.func_220320_c();
            }
            if (original.func_225437_d()) {
                clone.func_225435_d();
            }
            return clone.func_220321_a(original.func_220333_h(), original.func_220344_i()).func_233607_a_((Block[])original.field_233593_bg_.toArray((Object[])new Block[0])).func_233606_a_(original.func_233602_m_()).func_233608_b_(original.func_220332_l()).setShouldReceiveVelocityUpdates(original.func_220340_m());
        }

        public void registerSpawnPlacement() {
            TYPE_TO_SPECIES_MAP.put((EntityType<?>)this.entityType.get(), this);
            AnnotationHelper.registerSpawnPlacement(this);
        }

        public String getConfigName() {
            return (this.specialVariantName == null ? "vanilla replacement " : ConfigUtil.camelCaseToLowerSpace(this.specialVariantName) + " ") + this.family.configName;
        }

        public String getConfigNameSingular() {
            return (this.specialVariantName == null ? "vanilla replacement " : ConfigUtil.camelCaseToLowerSpace(this.specialVariantName) + " ") + ConfigUtil.camelCaseToLowerSpace(this.family.name);
        }

        public boolean isNotGiant() {
            if (this.isNotGiant == null) {
                this.isNotGiant = MathHelper.func_76123_f((float)((EntityType)this.entityType.get()).func_220344_i()) <= MathHelper.func_76123_f((float)this.family.replaceableTypes[0].func_220344_i());
            }
            return this.isNotGiant;
        }

        public float getHeightScale() {
            if (this.heightScale < 0.0f) {
                this.heightScale = ((EntityType)this.entityType.get()).func_220344_i() / this.family.replaceableTypes[0].func_220344_i();
            }
            return this.heightScale;
        }
    }
}

