/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.bestiary;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.field.DoubleField;
import fathertoast.specialmobs.common.config.util.AttributeEntry;
import fathertoast.specialmobs.common.config.util.AttributeList;
import fathertoast.specialmobs.common.config.util.ConfigUtil;
import fathertoast.specialmobs.common.config.util.EnvironmentEntry;
import fathertoast.specialmobs.common.config.util.EnvironmentList;
import fathertoast.specialmobs.common.config.util.LazyRegistryEntryList;
import fathertoast.specialmobs.common.config.util.RegistryEntryList;
import fathertoast.specialmobs.common.config.util.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.util.References;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BestiaryInfo {
    public final int eggSpotsColor;
    public final float baseScale;
    public final DefaultWeight defaultWeight;
    public final Theme theme;
    public final AttributeList defaultAttributes;
    public final ResourceLocation texture;
    public final ResourceLocation eyesTexture;
    public final ResourceLocation overlayTexture;
    public final int experience;
    public final int healTime;
    public final double fallDamageMultiplier;
    public final boolean isImmuneToFire;
    public final boolean isImmuneToBurning;
    public final boolean canBreatheInWater;
    public final boolean ignoreWaterPush;
    public final boolean isDamagedByWater;
    public final boolean allowLeashing;
    public final boolean ignorePressurePlates;
    public final RegistryEntryList<Block> immuneToStickyBlocks;
    public final RegistryEntryList<Effect> immuneToPotions;
    public final double rangedAttackDamage;
    public final double rangedAttackSpread;
    public final double rangedWalkSpeed;
    public final int rangedAttackCooldown;
    public final int rangedAttackMaxCooldown;
    public final double rangedAttackMaxRange;

    public static Builder of(MobFamily.Species<?> species, EntityType.Builder<?> typeBuilder) {
        return new Builder(species, typeBuilder);
    }

    private BestiaryInfo(int eggColor, float scale, DefaultWeight weight, Theme spawnTheme, List<AttributeEntry> attributes, ResourceLocation tex, ResourceLocation eyeTex, ResourceLocation ovrTex, int xp, int regen, double fallDmg, boolean fireImm, boolean burnImm, boolean drownImm, boolean pushImm, boolean waterDmg, boolean leash, boolean plateImm, Object[] blockImm, Object[] effectImm, double raDmg, double raVar, double raSpd, int raCD, int raMCD, double raRng) {
        this.eggSpotsColor = eggColor;
        this.baseScale = scale;
        this.defaultWeight = weight;
        this.theme = spawnTheme;
        this.defaultAttributes = new AttributeList(attributes);
        this.texture = tex;
        this.eyesTexture = eyeTex;
        this.overlayTexture = ovrTex;
        this.experience = xp;
        this.healTime = regen;
        this.fallDamageMultiplier = fallDmg;
        this.isImmuneToFire = fireImm;
        this.isImmuneToBurning = burnImm;
        this.canBreatheInWater = drownImm;
        this.ignoreWaterPush = pushImm;
        this.isDamagedByWater = waterDmg;
        this.allowLeashing = leash;
        this.ignorePressurePlates = plateImm;
        this.immuneToStickyBlocks = new LazyRegistryEntryList<Block>((IForgeRegistry<Block>)ForgeRegistries.BLOCKS, blockImm);
        this.immuneToPotions = new LazyRegistryEntryList<Effect>((IForgeRegistry<Effect>)ForgeRegistries.POTIONS, effectImm);
        this.rangedAttackDamage = raDmg;
        this.rangedAttackSpread = raVar;
        this.rangedWalkSpeed = raSpd;
        this.rangedAttackCooldown = raCD;
        this.rangedAttackMaxCooldown = raMCD;
        this.rangedAttackMaxRange = raRng;
    }

    public static final class Builder {
        private final MobFamily.Species<?> owningSpecies;
        private final EntityType.Builder<?> entityTypeBuilder;
        private boolean colorSet;
        private int eggSpotsColor;
        private DefaultWeight defaultWeight = DefaultWeight.DEFAULT;
        private Theme spawnTheme = Theme.NONE;
        private final List<AttributeEntry> attributes = new ArrayList<AttributeEntry>();
        private float baseScale = 1.0f;
        private ResourceLocation texture;
        private ResourceLocation eyesTexture;
        private ResourceLocation overlayTexture;
        private int experience = -1;
        private int healTime;
        private double fallDamageMultiplier = 1.0;
        private boolean isImmuneToFire;
        private boolean isImmuneToBurning;
        private boolean canBreatheInWater;
        private boolean ignoreWaterPush;
        private boolean isDamagedByWater;
        private boolean allowLeashing;
        private boolean ignorePressurePlates;
        private final ArrayList<Object> immuneToStickyBlocks = new ArrayList();
        private final ArrayList<Object> immuneToPotions = new ArrayList();
        private double rangedAttackDamage = -1.0;
        private double rangedAttackSpread = -1.0;
        private double rangedWalkSpeed = -1.0;
        private int rangedAttackCooldown = -1;
        private int rangedAttackMaxCooldown = -1;
        private double rangedAttackMaxRange = -1.0;

        private Builder(MobFamily.Species<?> species, EntityType.Builder<?> typeBuilder) {
            this.owningSpecies = species;
            this.entityTypeBuilder = typeBuilder;
            if (species.specialVariantName == null) {
                if (species.family.replaceableTypes[0].func_220338_c()) {
                    this.isImmuneToFire = true;
                }
            } else {
                BestiaryInfo parent = species.family.vanillaReplacement.bestiaryInfo;
                this.baseScale = parent.baseScale;
                this.texture = parent.texture;
                this.eyesTexture = parent.eyesTexture;
                this.overlayTexture = parent.overlayTexture;
                this.experience = parent.experience;
                this.healTime = parent.healTime;
                this.fallDamageMultiplier = parent.fallDamageMultiplier;
                this.isImmuneToFire = parent.isImmuneToFire;
                this.isImmuneToBurning = parent.isImmuneToBurning;
                this.canBreatheInWater = parent.canBreatheInWater;
                this.ignoreWaterPush = parent.ignoreWaterPush;
                this.isDamagedByWater = parent.isDamagedByWater;
                this.allowLeashing = parent.allowLeashing;
                this.ignorePressurePlates = parent.ignorePressurePlates;
                this.immuneToStickyBlocks.addAll(parent.immuneToStickyBlocks.getEntries());
                this.immuneToPotions.addAll(parent.immuneToPotions.getEntries());
                this.setAllRangedStats(parent.rangedAttackDamage, parent.rangedAttackSpread, parent.rangedWalkSpeed, parent.rangedAttackCooldown, parent.rangedAttackMaxCooldown, parent.rangedAttackMaxRange);
            }
        }

        BestiaryInfo build() {
            if (!this.colorSet) {
                throw new IllegalStateException("Species " + this.owningSpecies.name + " has not assigned egg spots color!");
            }
            if (this.experience < 0) {
                throw new IllegalStateException("Family " + this.owningSpecies.family.name + " has not set the base experience value!");
            }
            return new BestiaryInfo(this.eggSpotsColor, this.baseScale, this.defaultWeight, this.spawnTheme, this.attributes, this.texture, this.eyesTexture, this.overlayTexture, this.experience, this.healTime, this.fallDamageMultiplier, this.isImmuneToFire, this.isImmuneToBurning, this.canBreatheInWater, this.ignoreWaterPush, this.isDamagedByWater, this.allowLeashing, this.ignorePressurePlates, this.immuneToStickyBlocks.toArray(), this.immuneToPotions.toArray(), this.rangedAttackDamage, this.rangedAttackSpread, this.rangedWalkSpeed, this.rangedAttackCooldown, this.rangedAttackMaxCooldown, this.rangedAttackMaxRange);
        }

        public Builder color(int eggColor) {
            this.eggSpotsColor = eggColor;
            this.colorSet = true;
            return this;
        }

        public Builder weight(DefaultWeight weight) {
            this.defaultWeight = weight;
            return this;
        }

        public Builder theme(Theme theme) {
            this.spawnTheme = theme;
            return this;
        }

        public Builder familySize(float renderScale) {
            if (this.owningSpecies.specialVariantName != null) {
                throw new IllegalStateException("Special variant " + this.owningSpecies.specialVariantName + " cannot set family render scale!");
            }
            this.baseScale = renderScale;
            return this;
        }

        public Builder size(float renderScale, float width, float height) {
            this.baseScale = renderScale;
            this.entityTypeBuilder.func_220321_a(width, height);
            return this;
        }

        public Builder vanillaTexturesAll(String tex, String eyeTex, String ovrTex) {
            return this.vanillaBaseTexture(tex).vanillaEyesTexture(eyeTex).vanillaOverlayTexture(ovrTex);
        }

        public Builder vanillaTextureWithEyes(String tex, String eyeTex) {
            return this.vanillaBaseTexture(tex).vanillaEyesTexture(eyeTex).noOverlayTexture();
        }

        public Builder vanillaTextureWithOverlay(String tex, String ovrTex) {
            return this.vanillaBaseTexture(tex).noEyesTexture().vanillaOverlayTexture(ovrTex);
        }

        public Builder vanillaTextureWithAnimation(String tex, String aniTex) {
            return this.vanillaTextureWithOverlay(tex, aniTex);
        }

        public Builder vanillaTextureBaseOnly(String tex) {
            return this.vanillaBaseTexture(tex).noEyesTexture().noOverlayTexture();
        }

        private Builder vanillaBaseTexture(String tex) {
            return this.baseTexture(new ResourceLocation(tex));
        }

        private Builder vanillaEyesTexture(String eyeTex) {
            return this.eyesTexture(new ResourceLocation(eyeTex));
        }

        private Builder vanillaOverlayTexture(String ovrTex) {
            return this.overlayTexture(new ResourceLocation(ovrTex));
        }

        public Builder uniqueTexturesAll() {
            return this.uniqueBaseTexture().uniqueEyesTexture().uniqueOverlayTexture();
        }

        public Builder uniqueTextureWithEyes() {
            return this.uniqueBaseTexture().uniqueEyesTexture().noOverlayTexture();
        }

        public Builder uniqueTextureWithOverlay() {
            return this.uniqueBaseTexture().noEyesTexture().uniqueOverlayTexture();
        }

        public Builder uniqueTextureWithAnimation() {
            return this.uniqueBaseTexture().noEyesTexture().uniqueAnimationTexture();
        }

        public Builder uniqueTextureBaseOnly() {
            return this.uniqueBaseTexture().noEyesTexture().noOverlayTexture();
        }

        private Builder uniqueBaseTexture() {
            return this.baseTexture(this.getBaseTexture());
        }

        public Builder uniqueEyesTexture() {
            return this.eyesTexture(this.getEyesTexture());
        }

        public Builder uniqueOverlayTexture() {
            return this.overlayTexture(this.getOverlayTexture());
        }

        public Builder uniqueAnimationTexture() {
            return this.overlayTexture(this.getShootingTexture());
        }

        private ResourceLocation getBaseTexture() {
            return this.toTexture("");
        }

        private ResourceLocation getEyesTexture() {
            return this.toTexture("_eyes");
        }

        private ResourceLocation getOverlayTexture() {
            return this.toTexture("_overlay");
        }

        private ResourceLocation getShootingTexture() {
            return this.toTexture("_shooting");
        }

        private ResourceLocation toTexture(String suffix) {
            return References.getEntityTexture(ConfigUtil.camelCaseToLowerUnderscore(this.owningSpecies.family.name), ConfigUtil.camelCaseToLowerUnderscore(this.owningSpecies.specialVariantName), suffix);
        }

        public Builder noEyesTexture() {
            return this.eyesTexture(null);
        }

        public Builder noOverlayTexture() {
            return this.overlayTexture(null);
        }

        public Builder noAnimationTexture() {
            return this.noOverlayTexture();
        }

        private Builder baseTexture(@Nullable ResourceLocation tex) {
            this.texture = tex;
            return this;
        }

        private Builder eyesTexture(@Nullable ResourceLocation eyeTex) {
            this.eyesTexture = eyeTex;
            return this;
        }

        private Builder overlayTexture(@Nullable ResourceLocation ovrTex) {
            this.overlayTexture = ovrTex;
            return this;
        }

        public Builder undead() {
            return this.drownImmune().effectImmune(Effects.field_76428_l, Effects.field_76436_u);
        }

        public Builder spider() {
            return this.webImmune().effectImmune(Effects.field_76436_u);
        }

        public Builder experience(int xp) {
            this.experience = xp;
            return this;
        }

        public Builder addExperience(int xp) {
            return this.experience(this.experience + xp);
        }

        public Builder regen(int time) {
            this.healTime = time;
            return this;
        }

        public Builder fallImmune() {
            return this.fallDamage(0.0);
        }

        public Builder fallDamage(double multiplier) {
            this.fallDamageMultiplier = multiplier;
            return this;
        }

        public Builder fireImmune() {
            this.entityTypeBuilder.func_220320_c();
            this.isImmuneToFire = true;
            return this;
        }

        public Builder burnImmune() {
            this.isImmuneToBurning = true;
            return this;
        }

        public Builder drownImmune() {
            this.canBreatheInWater = true;
            return this;
        }

        public Builder fluidPushImmune() {
            this.ignoreWaterPush = true;
            return this;
        }

        public Builder waterSensitive() {
            this.isDamagedByWater = true;
            return this;
        }

        public Builder waterInsensitive() {
            this.isDamagedByWater = false;
            return this;
        }

        public Builder leashable() {
            this.allowLeashing = true;
            return this;
        }

        public Builder pressurePlateImmune() {
            this.ignorePressurePlates = true;
            return this;
        }

        public Builder hazardImmune(Block ... hazards) {
            this.entityTypeBuilder.func_233607_a_(hazards);
            return this;
        }

        public Builder webImmune() {
            return this.stickyBlockImmune(Blocks.field_196553_aF);
        }

        public Builder stickyBlockImmune(Object ... blocks) {
            this.immuneToStickyBlocks.addAll(Arrays.asList(blocks));
            return this;
        }

        public Builder effectImmune(Object ... effects) {
            this.immuneToPotions.addAll(Arrays.asList(effects));
            return this;
        }

        public Builder bowAttack(double damage, double spread, double walkSpeed, int cooldown, double range) {
            return this.rangedDamage(damage).rangedSpread(spread).rangedWalkSpeed(walkSpeed).rangedCooldown(cooldown).rangedMaxRange(range);
        }

        public Builder throwAttack(double spread, double walkSpeed, int cooldown, double range) {
            return this.rangedSpread(spread).rangedWalkSpeed(walkSpeed).rangedCooldown(cooldown).rangedMaxRange(range);
        }

        public Builder fireballAttack(double spread, int charge, int cooldown, double range) {
            return this.rangedSpread(spread).rangedCooldown(charge).rangedMaxCooldown(charge + cooldown).rangedMaxRange(range);
        }

        public Builder spitAttack(double damage, double spread, int cooldown, int extraCooldown, double range) {
            return this.rangedDamage(damage).rangedSpread(spread).rangedCooldown(cooldown).rangedMaxCooldown(cooldown + extraCooldown).rangedMaxRange(range);
        }

        public Builder spitAttackMultiplied(double damage, double spread, float cooldown, double range) {
            return this.multiplyRangedDamage(damage).multiplyRangedSpread(spread).multiplyRangedCooldown(cooldown).multiplyRangedMaxCooldown(cooldown).multiplyRangedMaxRange(range);
        }

        public Builder convertRangedAttackToFishing(double spread, int cooldown, double range) {
            return this.setAllRangedStats(-1.0, spread, -1.0, cooldown, -1, range);
        }

        public Builder convertRangedAttackToBeam(double damage, double turnSpeed, int charge, int duration, double range) {
            return this.setAllRangedStats(damage, -1.0, turnSpeed, charge, charge + duration, range);
        }

        public Builder disableRangedAttack() {
            return this.rangedMaxRange(0.0);
        }

        public Builder addToRangedDamage(double value) {
            return this.rangedDamage(this.rangedAttackDamage + value);
        }

        public Builder multiplyRangedDamage(double value) {
            return this.rangedDamage(this.rangedAttackDamage * value);
        }

        public Builder rangedDamage(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackDamage < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackDamage = value;
            return this;
        }

        public Builder multiplyRangedSpread(double value) {
            return this.rangedSpread(this.rangedAttackSpread * value);
        }

        public Builder rangedSpread(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackSpread < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackSpread = value;
            return this;
        }

        public Builder multiplyRangedWalkSpeed(double value) {
            return this.rangedWalkSpeed(this.rangedWalkSpeed * value);
        }

        public Builder rangedWalkSpeed(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedWalkSpeed < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedWalkSpeed = value;
            return this;
        }

        public Builder multiplyRangedCooldown(float value) {
            return this.rangedCooldown(Math.round((float)this.rangedAttackCooldown * value));
        }

        public Builder rangedCooldown(int value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackCooldown < 0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackCooldown = value;
            return this;
        }

        public Builder multiplyRangedMaxCooldown(float value) {
            return this.rangedCooldown(Math.round((float)this.rangedAttackMaxCooldown * value));
        }

        public Builder rangedMaxCooldown(int value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackMaxCooldown < 0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackMaxCooldown = value;
            return this;
        }

        public Builder multiplyRangedMaxRange(double value) {
            return this.rangedMaxRange(this.rangedAttackMaxRange * value);
        }

        public Builder rangedMaxRange(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackMaxRange < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackMaxRange = value;
            return this;
        }

        private Builder setAllRangedStats(double damage, double spread, double walkSpeed, int cooldown, int maxCooldown, double range) {
            this.rangedAttackDamage = damage;
            this.rangedAttackSpread = spread;
            this.rangedWalkSpeed = walkSpeed;
            this.rangedAttackCooldown = cooldown;
            this.rangedAttackMaxCooldown = maxCooldown;
            this.rangedAttackMaxRange = range;
            return this;
        }

        public Builder addToAttribute(Attribute attribute, double value) {
            if (attribute == Attributes.field_233821_d_) {
                throw new IllegalArgumentException("Do not add flat movement speed!");
            }
            this.attributes.add(AttributeEntry.add(attribute, value));
            return this;
        }

        public Builder multiplyAttribute(Attribute attribute, double value) {
            this.attributes.add(AttributeEntry.mult(attribute, value));
            return this;
        }
    }

    public static enum Theme {
        NONE(new EnvironmentList(new EnvironmentEntry[0])),
        FIRE(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).isHot().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).isWarm().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).isFreezing().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203614_T).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203617_W).build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).inBiome((RegistryKey<Biome>)Biomes.field_203615_U).build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).inBiome((RegistryKey<Biome>)Biomes.field_203618_X).build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).inBiome((RegistryKey<Biome>)Biomes.field_203616_V).build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).inBiome((RegistryKey<Biome>)Biomes.field_203619_Y).build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203620_Z).build())),
        ICE(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).isFreezing().build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).isWarm().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).isHot().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203620_Z).build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).inBiome((RegistryKey<Biome>)Biomes.field_203616_V).build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).inBiome((RegistryKey<Biome>)Biomes.field_203619_Y).build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).inBiome((RegistryKey<Biome>)Biomes.field_203615_U).build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).inBiome((RegistryKey<Biome>)Biomes.field_203618_X).build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203614_T).build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203617_W).build())),
        DESERT(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inNaturalDimension().inDryBiome().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inWaterBiome().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inHumidBiome().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).isRaining().canSeeSky().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).belowHalfMoonLight().build())),
        WATER(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder(DefaultWeight.LOWEST.value).inNaturalDimension().inDryBiome().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inWaterBiome().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inHumidBiome().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).isRaining().canSeeSky().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).aboveHalfMoonLight().build())),
        FOREST(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.TAIGA).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.JUNGLE).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.FOREST).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.SWAMP).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_235253_az_).build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).atMaxMoonLight().build())),
        MOUNTAIN(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inMountainBiome().build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).aboveMountainLevel().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).atNoMoonLight().build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).belowSeaLevel().build())),
        STORM(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).isThundering().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).isRaining().build(), EnvironmentEntry.builder(DefaultWeight.LOW.value).cannotSeeSky().build())),
        TROPICAL(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203614_T).build(), EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inBiome((RegistryKey<Biome>)Biomes.field_203617_W).build(), EnvironmentEntry.builder(DefaultWeight.DISABLED.value).isFreezing().build(), EnvironmentEntry.builder(DefaultWeight.DISABLED.value).inBiome((RegistryKey<Biome>)Biomes.field_203620_Z).build())),
        FISHING(new EnvironmentList(EnvironmentEntry.builder(DefaultWeight.HIGHEST.value).inWaterBiome().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).atMaxMoonLight().build(), EnvironmentEntry.builder(DefaultWeight.HIGH.value).isRaining().notInDryBiome().build()));

        public final EnvironmentList value;

        private Theme(EnvironmentList v) {
            this.value = v.setRange(DoubleField.Range.NON_NEGATIVE);
        }
    }

    public static enum DefaultWeight {
        DEFAULT(60.0),
        DISABLED(0.0),
        LOWEST(DefaultWeight.DEFAULT.value / 8.0),
        LOW(DefaultWeight.DEFAULT.value / 4.0),
        HIGH(DefaultWeight.DEFAULT.value * 2.5),
        HIGHEST(DefaultWeight.DEFAULT.value * 5.0);

        public final double value;

        private DefaultWeight(double v) {
            this.value = v;
        }
    }
}

