/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.species;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialEndermanRenderer;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EndermanModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RunicEndermanRenderer
extends SpecialEndermanRenderer {
    public static final ResourceLocation BEAM_TEXTURE_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType BEAM = RenderType.func_228646_f_((ResourceLocation)BEAM_TEXTURE_LOCATION);

    public RunicEndermanRenderer(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void func_225623_a_(EndermanEntity entity, float rotation, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        RunicEndermanEntity.BeamState beamState = ((RunicEndermanEntity)entity).getBeamState();
        if (beamState != RunicEndermanEntity.BeamState.OFF) {
            matrixStack.func_227860_a_();
            Vector3d beamVec = entity.func_70676_i(partialTicks).func_186678_a(32.0);
            Vector3d beamStartPos = entity.func_174824_e(partialTicks);
            Vector3d beamEndPos = beamStartPos.func_178787_e(beamVec);
            BlockRayTraceResult blockRayTrace = entity.field_70170_p.func_217299_a(new RayTraceContext(beamStartPos, beamEndPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
            if (blockRayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
                beamVec = blockRayTrace.func_216347_e().func_178788_d(beamStartPos);
            }
            this.renderBeamAttack(beamState, entity.func_70047_e(), (float)beamVec.field_72450_a, (float)beamVec.field_72448_b, (float)beamVec.field_72449_c, partialTicks, entity.field_70173_aa, matrixStack, buffer, packedLight);
            matrixStack.func_227865_b_();
        }
        super.func_225623_a_(entity, rotation, partialTicks, matrixStack, buffer, packedLight);
    }

    protected boolean isBodyVisible(EndermanEntity entity) {
        RunicEndermanEntity.BeamState beamState = ((RunicEndermanEntity)entity).getBeamState();
        if (beamState != RunicEndermanEntity.BeamState.OFF) {
            float zRot = beamState == RunicEndermanEntity.BeamState.DAMAGING ? 0.25f : 0.6f;
            EndermanModel model = (EndermanModel)this.func_217764_d();
            model.field_178724_i.field_78795_f = -0.6f;
            model.field_178723_h.field_78795_f = -0.6f;
            model.field_178724_i.field_78808_h = -zRot;
            model.field_178723_h.field_78808_h = zRot;
        }
        return super.func_225622_a_((LivingEntity)entity);
    }

    private void renderBeamAttack(RunicEndermanEntity.BeamState beamState, float offsetY, float dX, float dY, float dZ, float partialTicks, int tickCount, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        float v1;
        float endScale;
        int c2;
        int c1;
        matrixStack.func_227860_a_();
        float dH = MathHelper.func_76129_c((float)(dX * dX + dZ * dZ));
        float length = MathHelper.func_76129_c((float)(dX * dX + dY * dY + dZ * dZ));
        matrixStack.func_227861_a_(0.0, (double)offsetY, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(-Math.atan2(dZ, dX)) - 1.5707964f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_((float)(-Math.atan2(dH, dY)) - 1.5707964f));
        IVertexBuilder vertexBuilder = buffer.getBuffer(BEAM);
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        Matrix4f pose = matrixEntry.func_227870_a_();
        Matrix3f normal = matrixEntry.func_227872_b_();
        if (beamState == RunicEndermanEntity.BeamState.DAMAGING) {
            c1 = 0;
            c2 = 255;
            endScale = 1.0f;
            v1 = ((float)tickCount + partialTicks) * -0.01f;
        } else {
            c1 = 100;
            c2 = 100;
            endScale = 0.2f;
            v1 = ((float)tickCount + partialTicks) * 0.006f;
        }
        float v2 = length / 32.0f + v1;
        float u1 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.75f;
        int resolution = 8;
        for (int n = 1; n <= 8; ++n) {
            float u2 = (float)n / 8.0f;
            float angle = u2 * (float)Math.PI * 2.0f;
            float x2 = MathHelper.func_76126_a((float)angle) * 0.75f;
            float y2 = MathHelper.func_76134_b((float)angle) * 0.75f;
            vertexBuilder.func_227888_a_(pose, x1 * 0.2f, y1 * 0.2f, 0.0f).func_225586_a_(c1, c1, c1, 255).func_225583_a_(u1, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(pose, x1 * endScale, y1 * endScale, length).func_225586_a_(c2, 100, c2, 255).func_225583_a_(u1, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(pose, x2 * endScale, y2 * endScale, length).func_225586_a_(c2, 100, c2, 255).func_225583_a_(u2, v2).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
            vertexBuilder.func_227888_a_(pose, x2 * 0.2f, y2 * 0.2f, 0.0f).func_225586_a_(c1, c1, c1, 255).func_225583_a_(u2, v1).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, -1.0f, 0.0f).func_181675_d();
            x1 = x2;
            y1 = y2;
            u1 = u2;
        }
        matrixStack.func_227865_b_();
    }
}

