/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.species;

import com.mojang.blaze3d.matrix.MatrixStack;
import fathertoast.specialmobs.client.misc.SMRenderTypes;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialGhastEyesLayer;
import fathertoast.specialmobs.client.renderer.entity.species.CorporealShiftGhastModel;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.util.References;
import java.util.function.Function;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CorporealShiftGhastRenderer
extends MobRenderer<CorporealShiftGhastEntity, CorporealShiftGhastModel<CorporealShiftGhastEntity>> {
    private static final Function<ResourceLocation, RenderType> INCORPOREAL = resourceLocation -> SMRenderTypes.entityCutoutNoCullBlend(resourceLocation, SMRenderTypes.INCORPOREAL_ALPHA);
    private static final ResourceLocation EYES = References.getEntityEyesTexture("ghast", "corporeal_shift");
    private static final ResourceLocation SHOOT_EYES = References.getEntityShootingEyesTexture("ghast", "corporeal_shift");
    private final float baseShadowRadius;

    public CorporealShiftGhastRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, new CorporealShiftGhastModel(), 1.5f);
        this.func_177094_a((LayerRenderer)new SpecialGhastEyesLayer(this, EYES, SHOOT_EYES));
        this.baseShadowRadius = this.field_76989_e;
    }

    public void render(CorporealShiftGhastEntity ghast, float rotation, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        ((CorporealShiftGhastModel)this.field_77045_g).field_228281_q_ = ghast.isCorporeal() ? RenderType::func_228640_c_ : INCORPOREAL;
        super.func_225623_a_((MobEntity)ghast, rotation, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(CorporealShiftGhastEntity entity) {
        SpecialMobData data = entity.getSpecialData();
        return entity.func_110182_bF() && data.getTextureOverlay() != null ? data.getTextureOverlay() : data.getTexture();
    }

    protected void scale(CorporealShiftGhastEntity entity, MatrixStack matrixStack, float partialTick) {
        float scale = 4.5f * entity.getSpecialData().getRenderScale();
        this.field_76989_e = this.baseShadowRadius * scale;
        matrixStack.func_227862_a_(scale, scale, scale);
    }
}

