/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.projectile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import fathertoast.specialmobs.common.entity.projectile.SpecialFishingBobberEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialFishingBobberRenderer
extends EntityRenderer<SpecialFishingBobberEntity> {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.func_228638_b_((ResourceLocation)TEXTURE_LOCATION);

    public SpecialFishingBobberRenderer(EntityRendererManager rendererManager) {
        super(rendererManager);
    }

    public void render(SpecialFishingBobberEntity entity, float rotation, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        LivingEntity angler = entity.getLivingOwner();
        if (angler == null) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        MatrixStack.Entry matrixEntry = matrixStack.func_227866_c_();
        SpecialFishingBobberRenderer.drawQuad(buffer.getBuffer(RENDER_TYPE), matrixEntry.func_227870_a_(), matrixEntry.func_227872_b_(), packedLight);
        matrixStack.func_227865_b_();
        ItemStack heldItem = angler.func_184614_ca();
        int handedness = heldItem.func_77973_b() != Items.field_151112_aM && heldItem.func_77973_b() != Items.field_151055_y ? 0 : (angler.func_184591_cq() == HandSide.RIGHT ? 1 : -1);
        double forwardOffset = 0.5;
        double rightwardOffset = (double)handedness * 0.35;
        double upwardOffset = angler.func_70047_e() - (angler.func_213453_ef() ? 0.1875f : 0.0f);
        float yRot = MathHelper.func_219799_g((float)partialTicks, (float)angler.field_70760_ar, (float)angler.field_70761_aq) * (float)Math.PI / 180.0f;
        double forwardX = MathHelper.func_76126_a((float)yRot);
        double forwardZ = MathHelper.func_76134_b((float)yRot);
        double xRod = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70169_q, (double)angler.func_226277_ct_()) - forwardX * 0.5 - forwardZ * rightwardOffset;
        double yRod = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70167_r, (double)angler.func_226278_cu_()) + upwardOffset;
        double zRod = MathHelper.func_219803_d((double)partialTicks, (double)angler.field_70166_s, (double)angler.func_226281_cx_()) + forwardZ * 0.5 - forwardX * rightwardOffset;
        double xBobber = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_());
        double yBobber = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_()) + 0.25;
        double zBobber = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_());
        SpecialFishingBobberRenderer.drawLine(buffer.getBuffer(RenderType.func_228659_m_()), matrixStack.func_227866_c_().func_227870_a_(), 16, xBobber, yBobber, zBobber, xRod, yRod, zRod);
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, rotation, partialTicks, matrixStack, buffer, packedLight);
    }

    private static void drawQuad(IVertexBuilder vertexBuilder, Matrix4f pose, Matrix3f normal, int packedLight) {
        SpecialFishingBobberRenderer.quadVertex(vertexBuilder, pose, normal, packedLight, 0.0f, 0.0f, 0, 1);
        SpecialFishingBobberRenderer.quadVertex(vertexBuilder, pose, normal, packedLight, 1.0f, 0.0f, 1, 1);
        SpecialFishingBobberRenderer.quadVertex(vertexBuilder, pose, normal, packedLight, 1.0f, 1.0f, 1, 0);
        SpecialFishingBobberRenderer.quadVertex(vertexBuilder, pose, normal, packedLight, 0.0f, 1.0f, 0, 0);
    }

    private static void quadVertex(IVertexBuilder vertexBuilder, Matrix4f pose, Matrix3f normal, int packedLight, float dX, float dY, int u, int v) {
        vertexBuilder.func_227888_a_(pose, dX - 0.5f, dY - 0.5f, 0.0f).func_225586_a_(255, 255, 255, 255).func_225583_a_((float)u, (float)v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(packedLight).func_227887_a_(normal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void drawLine(IVertexBuilder vertexBuilder, Matrix4f pose, int resolution, double x1, double y1, double z1, double x2, double y2, double z2) {
        float dX = (float)(x2 - x1);
        float dY = (float)(y2 - y1);
        float dZ = (float)(z2 - z1);
        for (int segment = 0; segment < resolution; ++segment) {
            SpecialFishingBobberRenderer.lineVertex(dX, dY, dZ, vertexBuilder, pose, segment, resolution);
            SpecialFishingBobberRenderer.lineVertex(dX, dY, dZ, vertexBuilder, pose, segment + 1, resolution);
        }
    }

    private static void lineVertex(float dX, float dY, float dZ, IVertexBuilder vertexBuilder, Matrix4f pose, int segment, int totalSegments) {
        float r = (float)segment / (float)totalSegments;
        vertexBuilder.func_227888_a_(pose, dX * r, dY * (r * r + r) * 0.5f + 0.25f, dZ * r).func_225586_a_(0, 0, 0, 255).func_181675_d();
    }

    public ResourceLocation getTextureLocation(SpecialFishingBobberEntity entity) {
        return TEXTURE_LOCATION;
    }
}

