/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.References;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialCreeperChargeLayer<T extends CreeperEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation[] CHARGED = new ResourceLocation[]{new ResourceLocation("textures/entity/creeper/creeper_armor.png"), References.getEntityTexture("creeper", "super_charged")};
    private final M model;

    public SpecialCreeperChargeLayer(IEntityRenderer<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T creeper, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (creeper.func_225509_J__() || ((_SpecialCreeperEntity)creeper).isSupercharged()) {
            float tickAndPartial = (float)((CreeperEntity)creeper).field_70173_aa + partialTicks;
            float textureOffset = tickAndPartial * 0.01f;
            this.model.func_212843_a_(creeper, limbSwing, limbSwingAmount, partialTicks);
            this.func_215332_c().func_217111_a(this.model);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228636_a_((ResourceLocation)this.getTextureLocation((CreeperEntity)creeper), (float)textureOffset, (float)textureOffset));
            this.model.func_225597_a_(creeper, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
        }
    }

    protected ResourceLocation getTextureLocation(CreeperEntity creeper) {
        return ((_SpecialCreeperEntity)creeper).isSupercharged() ? CHARGED[1] : CHARGED[0];
    }
}

