/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.family;

import com.mojang.blaze3d.matrix.MatrixStack;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialMobEyesLayer;
import fathertoast.specialmobs.client.renderer.entity.layers.SpecialMobOverlayLayer;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PiglinModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpecialPiglinRenderer
extends PiglinRenderer {
    private final float baseShadowRadius;

    public static SpecialPiglinRenderer newBothEars(EntityRendererManager rendererManager) {
        return new SpecialPiglinRenderer(rendererManager, false);
    }

    public static SpecialPiglinRenderer newMissingRightEar(EntityRendererManager rendererManager) {
        return new SpecialPiglinRenderer(rendererManager, true);
    }

    public SpecialPiglinRenderer(EntityRendererManager rendererManager, boolean missingRightEar) {
        super(rendererManager, missingRightEar);
        this.baseShadowRadius = this.field_76989_e;
        this.func_177094_a((LayerRenderer)new SpecialMobEyesLayer(this));
        PiglinModel model = new PiglinModel(0.25f, 64, 64);
        if (missingRightEar) {
            model.field_239116_b_.field_78806_j = false;
        }
        this.func_177094_a(new SpecialMobOverlayLayer(this, model));
    }

    public ResourceLocation func_110775_a(MobEntity entity) {
        return ((ISpecialMob)entity).getSpecialData().getTexture();
    }

    protected void scale(MobEntity entity, MatrixStack matrixStack, float partialTick) {
        super.func_225620_a_((LivingEntity)entity, matrixStack, partialTick);
        float scale = ((ISpecialMob)entity).getSpecialData().getRenderScale();
        this.field_76989_e = this.baseShadowRadius * scale;
        matrixStack.func_227862_a_(scale, scale, scale);
    }
}

