/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client;

import fathertoast.specialmobs.client.ClientEventHandler;
import fathertoast.specialmobs.client.FishingRodItemPropertyGetter;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialBlazeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialCreeperRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialDrownedRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialEndermanRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialGhastRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialMagmaCubeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialPiglinRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSilverfishRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSkeletonRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSlimeRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialSpiderRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialWitchRenderer;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialZombieRenderer;
import fathertoast.specialmobs.client.renderer.entity.projectile.BoneShrapnelRenderer;
import fathertoast.specialmobs.client.renderer.entity.projectile.BugSpitRenderer;
import fathertoast.specialmobs.client.renderer.entity.projectile.SpecialFishingBobberRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.CorporealShiftGhastRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.EnderCreeperRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.NinjaSkeletonRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.PotionSlimeRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.RunicEndermanRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.ShortSilverfishRenderer;
import fathertoast.specialmobs.client.renderer.entity.species.SpecialZombieVillagerRenderer;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.creeper.EnderCreeperEntity;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.entity.silverfish.PufferSilverfishEntity;
import fathertoast.specialmobs.common.entity.skeleton.NinjaSkeletonEntity;
import fathertoast.specialmobs.common.entity.slime.PotionSlimeEntity;
import fathertoast.specialmobs.common.entity.witherskeleton.NinjaWitherSkeletonEntity;
import fathertoast.specialmobs.common.entity.zombie.MadScientistZombieEntity;
import fathertoast.specialmobs.common.entity.zombifiedpiglin.VampireZombifiedPiglinEntity;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegister {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        RenderTypeLookup.setRenderLayer((Block)((Block)SMBlocks.MELTING_ICE.get()), (RenderType)RenderType.func_228645_f_());
        if (Config.MAIN.GENERAL.fancyFishingMobs.get()) {
            ItemModelsProperties.func_239418_a_((Item)Items.field_151112_aM, (ResourceLocation)new ResourceLocation("cast"), (IItemPropertyGetter)new FishingRodItemPropertyGetter());
        }
        ClientEventHandler.registerConfigGUIFactory();
        ClientRegister.registerEntityRenderers(event.getMinecraftSupplier());
    }

    private static void registerEntityRenderers(Supplier<Minecraft> game) {
        ClientRegister.registerFamilyRenderers(MobFamily.CREEPER, SpecialCreeperRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.ZOMBIE, SpecialZombieRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.DROWNED, SpecialDrownedRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.ZOMBIFIED_PIGLIN, SpecialPiglinRenderer::newMissingRightEar);
        ClientRegister.registerFamilyRenderers(MobFamily.SKELETON, SpecialSkeletonRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.WITHER_SKELETON, SpecialSkeletonRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.SLIME, SpecialSlimeRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.MAGMA_CUBE, SpecialMagmaCubeRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.SPIDER, SpecialSpiderRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.CAVE_SPIDER, SpecialSpiderRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.SILVERFISH, SpecialSilverfishRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.ENDERMAN, SpecialEndermanRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.WITCH, SpecialWitchRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.GHAST, SpecialGhastRenderer::new);
        ClientRegister.registerFamilyRenderers(MobFamily.BLAZE, SpecialBlazeRenderer::new);
        ClientRegister.registerSpeciesRenderer(EnderCreeperEntity.SPECIES, EnderCreeperRenderer::new);
        ClientRegister.registerSpeciesRenderer(MadScientistZombieEntity.SPECIES, SpecialZombieVillagerRenderer::new);
        ClientRegister.registerSpeciesRenderer(VampireZombifiedPiglinEntity.SPECIES, SpecialPiglinRenderer::newBothEars);
        ClientRegister.registerSpeciesRenderer(NinjaSkeletonEntity.SPECIES, NinjaSkeletonRenderer::new);
        ClientRegister.registerSpeciesRenderer(NinjaWitherSkeletonEntity.SPECIES, NinjaSkeletonRenderer::new);
        ClientRegister.registerSpeciesRenderer(PotionSlimeEntity.SPECIES, PotionSlimeRenderer::new);
        ClientRegister.registerSpeciesRenderer(PufferSilverfishEntity.SPECIES, ShortSilverfishRenderer::new);
        ClientRegister.registerSpeciesRenderer(CorporealShiftGhastEntity.SPECIES, CorporealShiftGhastRenderer::new);
        ClientRegister.registerSpeciesRenderer(RunicEndermanEntity.SPECIES, RunicEndermanRenderer::new);
        ClientRegister.registerRenderer(SMEntities.BONE_SHRAPNEL, BoneShrapnelRenderer::new);
        ClientRegister.registerRenderer(SMEntities.BUG_SPIT, BugSpitRenderer::new);
        ClientRegister.registerSpriteRenderer(SMEntities.INCORPOREAL_FIREBALL, game, 3.0f, true);
        ClientRegister.registerRenderer(SMEntities.FISHING_BOBBER, SpecialFishingBobberRenderer::new);
    }

    private static <T extends LivingEntity> void registerFamilyRenderers(MobFamily<T, ?> family, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)family.vanillaReplacement.entityType.get()), renderFactory);
        for (MobFamily.Species species : family.variants) {
            ClientRegister.registerSpeciesRenderer(species, renderFactory);
        }
    }

    private static <T extends LivingEntity> void registerSpeciesRenderer(MobFamily.Species<T> species, IRenderFactory<? super T> renderFactory) {
        ClientRegister.registerRenderer(species.entityType, renderFactory);
    }

    private static <T extends Entity> void registerRenderer(RegistryObject<EntityType<T>> entityType, IRenderFactory<? super T> renderFactory) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)entityType.get()), renderFactory);
    }

    private static <T extends Entity> void registerSpriteRenderer(RegistryObject<EntityType<T>> entityType, Supplier<Minecraft> minecraftSupplier, float scale, boolean fullBright) {
        ItemRenderer itemRenderer = minecraftSupplier.get().func_175599_af();
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)entityType.get()), renderManager -> new SpriteRenderer(renderManager, itemRenderer, scale, fullBright));
    }
}

