/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin.sodium;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import me.jellysquid.mods.sodium.client.model.light.LightMode;
import me.jellysquid.mods.sodium.client.model.light.LightPipeline;
import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowTile;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.client.ClientVariables;

@Mixin(value={BlockRenderer.class}, remap=false)
public abstract class BlockRendererMixin {
    @Shadow
    private LightPipelineProvider lighters;
    @Shadow
    private Random random;
    @Shadow
    private BlockOcclusionCache occlusionCache;

    @Inject(method={"renderModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void srm_renderModel(IBlockDisplayReader lightReaderIn, BlockState blockStateIn, BlockPos posIn, IBakedModel model, ChunkModelBuffers buffers, boolean cull, long seed, IModelData modelData, CallbackInfoReturnable<Boolean> ci) {
        if (!(blockStateIn.func_177230_c() instanceof SnowVariant)) {
            return;
        }
        if (!blockStateIn.hasTileEntity()) {
            return;
        }
        if (blockStateIn.func_235901_b_((Property)SnowBlock.field_176315_a) && (Integer)blockStateIn.func_177229_b((Property)SnowBlock.field_176315_a) == 8) {
            return;
        }
        BlockState state = (BlockState)modelData.getData(SnowTile.BLOCKSTATE);
        if (state == null || !state.func_196958_f() && state.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        try {
            boolean canRender;
            RenderType cutoutMipped = RenderType.func_228641_d_();
            RenderType solid = RenderType.func_228639_c_();
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            boolean ret = false;
            Block blockIn = blockStateIn.func_177230_c();
            SnowTile.Options options = (SnowTile.Options)Optional.ofNullable(modelData.getData(SnowTile.OPTIONS)).orElse(ClientVariables.fallbackOptions);
            if (layer == null) {
                canRender = layer == cutoutMipped;
            } else {
                if (layer == solid && blockIn instanceof WatcherSnowVariant) {
                    ((WatcherSnowVariant)blockIn).updateOptions(blockStateIn, (IBlockReader)lightReaderIn, posIn, options);
                }
                canRender = RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer);
            }
            double yOffset = 0.0;
            if (canRender && !state.func_196958_f()) {
                String namespace;
                if (blockStateIn.func_235901_b_((Property)SnowBlock.field_176315_a) && ("projectvibrantjourneys".equals(namespace = state.func_177230_c().getRegistryName().func_110624_b()) || "foragecraft".equals(namespace))) {
                    if ((Integer)blockStateIn.func_177229_b((Property)SnowBlock.field_176315_a) > 3) {
                        return;
                    }
                    yOffset = 0.1;
                }
                ret |= this.renderModelWithYOffset(lightReaderIn, state, posIn, this.getBlockModel(state), buffers, cull, seed, modelData, yOffset);
            }
            if (options.renderBottom && (layer == null || layer == solid)) {
                if (ClientVariables.cachedSnowModel == null) {
                    ClientVariables.cachedSnowModel = this.getBlockModel(CoreModule.BLOCK.func_176223_P());
                }
                ret |= this.renderModel(lightReaderIn, CoreModule.BLOCK.func_176223_P(), posIn, ClientVariables.cachedSnowModel, buffers, cull, seed, modelData);
            }
            if (blockStateIn.func_203425_a((Block)CoreModule.SLAB) || blockIn instanceof SnowBlock) {
                if (options.renderOverlay && layer == cutoutMipped) {
                    if (ClientVariables.cachedOverlayModel == null) {
                        ClientVariables.cachedOverlayModel = Minecraft.func_71410_x().func_209506_al().getModel(CoreModule.OVERLAY_MODEL);
                    }
                    BlockPos pos = posIn;
                    if (blockStateIn.func_203425_a((Block)CoreModule.SLAB)) {
                        yOffset = -0.375;
                    } else {
                        yOffset = -1.0;
                        pos = pos.func_177977_b();
                    }
                    ret |= this.renderModelWithYOffset(lightReaderIn, CoreModule.BLOCK.func_176223_P(), posIn, ClientVariables.cachedOverlayModel, buffers, cull, seed, modelData, yOffset);
                }
            } else if (!options.renderOverlay) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if (blockStateIn.func_203425_a((Block)CoreModule.TILE_BLOCK)) {
                if (layer != solid) {
                    ci.setReturnValue((Object)ret);
                    return;
                }
            } else if (layer != cutoutMipped) {
                ci.setReturnValue((Object)ret);
                return;
            }
            yOffset = ((SnowVariant)blockIn).getYOffset();
            ci.setReturnValue((Object)(ret |= this.renderModelWithYOffset(lightReaderIn, blockStateIn, posIn, model, buffers, cull, seed, modelData, yOffset)));
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    private IBakedModel getBlockModel(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public boolean renderModelWithYOffset(IBlockDisplayReader world, BlockState state, BlockPos pos, IBakedModel model, ChunkModelBuffers buffers, boolean cull, long seed, IModelData modelData, double yOffset) {
        Vector3d offset = state.func_191059_e((IBlockReader)world, pos);
        if (yOffset != 0.0) {
            offset = offset.func_72441_c(0.0, yOffset, 0.0);
        }
        LightPipeline lighter = this.lighters.getLighter(this.getLightingMode(state, model));
        boolean rendered = false;
        for (Direction dir : DirectionUtil.ALL_DIRECTIONS) {
            this.random.setSeed(seed);
            List sided = model.getQuads(state, dir, this.random, modelData);
            if (sided.isEmpty() || cull && !this.occlusionCache.shouldDrawSide(state, (IBlockReader)world, pos, dir)) continue;
            this.renderQuadList(world, state, pos, lighter, offset, buffers, sided, ModelQuadFacing.fromDirection((Direction)dir));
            rendered = true;
        }
        this.random.setSeed(seed);
        List all = model.getQuads(state, null, this.random, modelData);
        if (!all.isEmpty()) {
            this.renderQuadList(world, state, pos, lighter, offset, buffers, all, ModelQuadFacing.UNASSIGNED);
            rendered = true;
        }
        return rendered;
    }

    @Shadow
    abstract boolean renderModel(IBlockDisplayReader var1, BlockState var2, BlockPos var3, IBakedModel var4, ChunkModelBuffers var5, boolean var6, long var7, IModelData var9);

    @Shadow
    abstract LightMode getLightingMode(BlockState var1, IBakedModel var2);

    @Shadow
    abstract void renderQuadList(IBlockDisplayReader var1, BlockState var2, BlockPos var3, LightPipeline var4, Vector3d var5, ChunkModelBuffers var6, List<BakedQuad> var7, ModelQuadFacing var8);
}

