/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.IModelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowTile;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.WatcherSnowVariant;
import snownee.snow.client.ClientVariables;

@Mixin(value={BlockRendererDispatcher.class})
public abstract class MixinBlockRendererDispatcher {
    @Shadow
    @Final
    private BlockModelRenderer field_175027_c;

    @Inject(method={"renderModel(Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/IBlockDisplayReader;Lcom/mojang/blaze3d/matrix/MatrixStack;Lcom/mojang/blaze3d/vertex/IVertexBuilder;ZLjava/util/Random;Lnet/minecraftforge/client/model/data/IModelData;)Z"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void srm_renderModel(BlockState blockStateIn, BlockPos posIn, IBlockDisplayReader lightReaderIn, MatrixStack matrixStackIn, IVertexBuilder vertexBuilderIn, boolean checkSides, Random rand, IModelData modelData, CallbackInfoReturnable<Boolean> ci) {
        if (!(blockStateIn.func_177230_c() instanceof SnowVariant)) {
            return;
        }
        if (!blockStateIn.hasTileEntity()) {
            return;
        }
        if (blockStateIn.func_235901_b_((Property)SnowBlock.field_176315_a) && (Integer)blockStateIn.func_177229_b((Property)SnowBlock.field_176315_a) == 8) {
            return;
        }
        BlockState state = (BlockState)modelData.getData(SnowTile.BLOCKSTATE);
        if (state == null || !state.func_196958_f() && state.func_185901_i() != BlockRenderType.MODEL) {
            return;
        }
        try {
            double yOffset;
            boolean canRender;
            RenderType cutoutMipped = RenderType.func_228641_d_();
            RenderType solid = RenderType.func_228639_c_();
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            boolean ret = false;
            Block blockIn = blockStateIn.func_177230_c();
            SnowTile.Options options = (SnowTile.Options)Optional.ofNullable(modelData.getData(SnowTile.OPTIONS)).orElse(ClientVariables.fallbackOptions);
            if (layer == null) {
                canRender = layer == cutoutMipped;
            } else {
                canRender = RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)layer);
                if (layer == solid && blockIn instanceof WatcherSnowVariant) {
                    ((WatcherSnowVariant)blockIn).updateOptions(blockStateIn, (IBlockReader)lightReaderIn, posIn, options);
                }
            }
            if (canRender) {
                String namespace;
                matrixStackIn.func_227860_a_();
                if (blockStateIn.func_235901_b_((Property)SnowBlock.field_176315_a) && ("projectvibrantjourneys".equals(namespace = state.func_177230_c().getRegistryName().func_110624_b()) || "foragecraft".equals(namespace))) {
                    if ((Integer)blockStateIn.func_177229_b((Property)SnowBlock.field_176315_a) > 3) {
                        matrixStackIn.func_227865_b_();
                        return;
                    }
                    matrixStackIn.func_227861_a_(0.001, 0.101, 0.001);
                    matrixStackIn.func_227862_a_(0.998f, 1.0f, 0.998f);
                }
                ret |= this.field_175027_c.renderModel(lightReaderIn, this.func_184389_a(state), state, posIn, matrixStackIn, vertexBuilderIn, false, rand, state.func_209533_a(posIn), OverlayTexture.field_229196_a_, modelData);
                matrixStackIn.func_227865_b_();
            }
            if (options.renderBottom && (layer == null || layer == solid)) {
                if (ClientVariables.cachedSnowModel == null) {
                    ClientVariables.cachedSnowModel = this.func_184389_a(CoreModule.BLOCK.func_176223_P());
                }
                ret |= this.field_175027_c.renderModel(lightReaderIn, ClientVariables.cachedSnowModel, CoreModule.BLOCK.func_176223_P(), posIn, matrixStackIn, vertexBuilderIn, false, rand, state.func_209533_a(posIn), OverlayTexture.field_229196_a_, modelData);
            }
            if (blockIn.func_235332_a_((Block)CoreModule.SLAB) || blockIn instanceof SnowBlock) {
                if (options.renderOverlay && layer == cutoutMipped) {
                    if (ClientVariables.cachedOverlayModel == null) {
                        ClientVariables.cachedOverlayModel = Minecraft.func_71410_x().func_209506_al().getModel(CoreModule.OVERLAY_MODEL);
                    }
                    matrixStackIn.func_227860_a_();
                    BlockPos pos = posIn;
                    if (blockIn.func_235332_a_((Block)CoreModule.SLAB)) {
                        matrixStackIn.func_227861_a_(-0.001, -0.375, -0.001);
                    } else {
                        matrixStackIn.func_227861_a_(-0.001, -1.0, -0.001);
                        pos = pos.func_177977_b();
                    }
                    ret |= this.field_175027_c.renderModel(lightReaderIn, ClientVariables.cachedOverlayModel, blockStateIn, pos, matrixStackIn, vertexBuilderIn, false, rand, blockStateIn.func_209533_a(pos), OverlayTexture.field_229196_a_, modelData);
                    matrixStackIn.func_227865_b_();
                }
            } else if (!options.renderOverlay) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if (blockIn.func_235332_a_((Block)CoreModule.TILE_BLOCK)) {
                if (layer != solid) {
                    ci.setReturnValue((Object)ret);
                    return;
                }
            } else if (layer != cutoutMipped) {
                ci.setReturnValue((Object)ret);
                return;
            }
            if ((yOffset = ((SnowVariant)blockIn).getYOffset()) != 0.0) {
                matrixStackIn.func_227861_a_(0.0, yOffset, 0.0);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)posIn, (BlockState)blockStateIn);
            throw new ReportedException(crashreport);
        }
    }

    @Shadow
    public abstract IBakedModel func_184389_a(BlockState var1);

    @Inject(at={@At(value="HEAD")}, method={"onResourceManagerReload"})
    private void srm_onResourceManagerReload(IResourceManager resourceManager, CallbackInfo ci) {
        ClientVariables.cachedSnowModel = null;
        ClientVariables.cachedOverlayModel = null;
    }
}

