/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.entity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ModSnowBlock;

public class FallingSnowEntity
extends Entity {
    public int fallTime;
    private BlockPos prevPos;
    private int layers;
    protected static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(FallingSnowEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> LAYERS = EntityDataManager.func_187226_a(FallingSnowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private EntitySize size;

    public FallingSnowEntity(World worldIn) {
        super(CoreModule.ENTITY, worldIn);
        this.prevPos = BlockPos.field_177992_a;
        this.layers = 1;
        this.size = new EntitySize(0.98f, 0.1225f * (float)this.layers, true);
    }

    public FallingSnowEntity(EntityType<FallingSnowEntity> type, World worldIn) {
        this(worldIn);
    }

    public FallingSnowEntity(World worldIn, double x, double y, double z, int layers) {
        super(CoreModule.ENTITY, worldIn);
        this.field_70156_m = true;
        this.func_70107_b(x, y + (double)((1.0f - this.func_213302_cg()) / 2.0f), z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.layers = layers;
        this.setData(this.func_233580_cy_(), layers);
        this.prevPos = this.func_233580_cy_();
        this.size = new EntitySize(0.98f, 0.1225f * (float)layers, true);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.size;
    }

    public void func_70071_h_() {
        ++this.fallTime;
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        BlockPos pos = this.func_233580_cy_();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70122_E) {
                if (this.fallTime > 100 && !this.field_70170_p.field_72995_K && (pos.func_177956_o() < 1 || pos.func_177956_o() > 256) || this.fallTime > 600) {
                    this.func_70106_y();
                } else if (!pos.equals((Object)this.prevPos)) {
                    this.prevPos = pos;
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (SnowCommonConfig.snowMakingIce && block == Blocks.field_150355_j) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
                        this.func_70106_y();
                        return;
                    }
                    if (state.func_204520_s().func_206884_a((ITag)FluidTags.field_206960_b)) {
                        if (this.field_70170_p.field_72995_K) {
                            Random random = this.field_70170_p.field_73012_v;
                            for (int i = 0; i < 10; ++i) {
                                double d0 = random.nextGaussian() * 0.02;
                                double d1 = random.nextGaussian() * 0.02;
                                double d2 = random.nextGaussian() * 0.02;
                                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + random.nextFloat()), d0, d1, d2);
                            }
                        }
                        this.field_70170_p.func_184133_a(null, pos.func_177984_a(), SoundEvents.field_187656_cX, SoundCategory.AMBIENT, 0.8f, 0.8f);
                        this.func_70106_y();
                        return;
                    }
                    if (!state.func_204520_s().func_206888_e()) {
                        this.func_70106_y();
                        return;
                    }
                }
            } else {
                BlockState state = this.field_70170_p.func_180495_p(pos);
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                if (state.func_177230_c() != Blocks.field_196603_bb) {
                    BlockPos posDown;
                    BlockState stateDown;
                    Block block;
                    if (state.func_215685_b((IBlockReader)this.field_70170_p, pos, ISelectionContext.func_216374_a((Entity)this)).func_197766_b() && ((block = (stateDown = this.field_70170_p.func_180495_p(posDown = pos.func_177977_b())).func_177230_c()) instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof StairsBlock && stateDown.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM)) {
                        pos = posDown;
                    }
                    ModSnowBlock.placeLayersOn(this.field_70170_p, pos, this.layers, true, (BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP), true);
                    this.func_70106_y();
                    return;
                }
            }
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
    }

    public void setData(BlockPos pos, int layers) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
        this.field_70180_af.func_187227_b(LAYERS, (Object)layers);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getLayers() {
        return (Integer)this.field_70180_af.func_187225_a(LAYERS);
    }

    @OnlyIn(value=Dist.CLIENT)
    public World getWorldObj() {
        return this.field_70170_p;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(LAYERS, (Object)1);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.fallTime = compound.func_74762_e("Time");
        if (compound.func_150297_b("Layers", 3)) {
            this.layers = compound.func_74762_e("Layers");
            this.size = new EntitySize(0.98f, 0.1225f * (float)this.layers, true);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Time", this.fallTime);
        compound.func_74768_a("Layers", this.layers);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

