/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeBlock;
import snownee.snow.WrappedSoundType;
import snownee.snow.block.SnowTile;

public interface SnowVariant
extends IForgeBlock {
    default public BlockState getRaw(BlockState state, IBlockReader world, BlockPos pos) {
        TileEntity tile;
        if (state.hasTileEntity() && (tile = world.func_175625_s(pos)) instanceof SnowTile) {
            return ((SnowTile)tile).getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    default public BlockState onShovel(BlockState state, World world, BlockPos pos) {
        return this.getRaw(state, (IBlockReader)world, pos);
    }

    default public double getYOffset() {
        return 0.0;
    }

    default public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getRaw(state, world, pos).getPickBlock(target, world, pos, player);
    }

    default public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        if (this.hasTileEntity(state) && !(state.func_177230_c() instanceof SnowBlock)) {
            return WrappedSoundType.get(this.getRaw(state, (IBlockReader)world, pos).getSoundType(world, pos, entity));
        }
        return super.getSoundType(state, world, pos, entity);
    }
}

