/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.kiwi.tile.BaseTile;
import snownee.kiwi.util.Util;
import snownee.snow.CoreModule;
import snownee.snow.block.SnowVariant;

public class SnowTile
extends BaseTile {
    public Options options = new Options();
    public static final ModelProperty<Options> OPTIONS = new ModelProperty();
    public static final ModelProperty<BlockState> BLOCKSTATE = new ModelProperty();
    protected BlockState state = Blocks.field_150350_a.func_176223_P();
    protected IModelData modelData;

    public SnowTile() {
        this(CoreModule.TILE);
    }

    public SnowTile(TileEntityType<?> type) {
        super(type);
    }

    public BlockState getState() {
        return this.state;
    }

    public void setState(BlockState state) {
        this.setState(state, true);
    }

    public boolean setState(BlockState state, boolean update) {
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        if (this.state == state || state.func_177230_c() instanceof SnowVariant) {
            return false;
        }
        this.state = state;
        if (this.func_145830_o()) {
            if (this.field_145850_b.field_72995_K) {
                this.getModelData().setData(BLOCKSTATE, (Object)state);
                this.onStateChanged();
            }
            if (update) {
                if (this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 11);
                } else {
                    this.refresh();
                }
            }
        }
        return true;
    }

    public void refresh() {
        super.refresh();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.loadState(state, compound, false);
    }

    protected void readPacketData(CompoundNBT data) {
        this.loadState(this.func_195044_w(), data, true);
    }

    public void loadState(BlockState state, CompoundNBT data, boolean network) {
        boolean changed = false;
        if (data.func_74764_b("RO") && (changed = this.options.update(data.func_74767_n("RO"), false)) && network && this.func_145830_o() && this.field_145850_b.field_72995_K) {
            this.requestModelDataUpdate();
        }
        if (data.func_74764_b("Block")) {
            ResourceLocation id = Util.RL((String)data.func_74779_i("Block"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block != null && block != Blocks.field_150350_a) {
                changed |= this.setState(block.func_176223_P(), network);
            }
        } else {
            changed |= this.setState(NBTUtil.func_190008_d((CompoundNBT)data.func_74775_l("State")), network);
        }
        if (changed && network) {
            this.refresh();
        }
    }

    public void saveState(CompoundNBT data, boolean network) {
        if (this.getState() == this.getState().func_177230_c().func_176223_P()) {
            data.func_74778_a("Block", this.getState().func_177230_c().getRegistryName().toString());
        } else {
            data.func_218657_a("State", (INBT)NBTUtil.func_190009_a((BlockState)this.getState()));
        }
        if (this.options.renderOverlay) {
            data.func_74757_a("RO", this.options.renderOverlay);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.saveState(compound, false);
        return compound;
    }

    protected CompoundNBT writePacketData(CompoundNBT data) {
        this.saveState(data, true);
        return data;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c);
    }

    public IModelData getModelData() {
        if (this.modelData == null) {
            this.modelData = new ModelDataMap.Builder().withInitial(BLOCKSTATE, (Object)this.state).withInitial(OPTIONS, (Object)this.options).build();
        }
        return this.modelData;
    }

    public void onStateChanged() {
        this.requestModelDataUpdate();
    }

    public static class Options {
        public boolean renderOverlay;
        public boolean renderBottom;

        public boolean update(boolean ro, boolean rb) {
            boolean changed = ro != this.renderOverlay || rb != this.renderBottom;
            this.renderOverlay = ro;
            this.renderBottom = rb;
            return changed;
        }
    }
}

