/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.Map;
import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowTile;
import snownee.snow.block.SnowVariant;
import snownee.snow.client.SnowClientConfig;
import snownee.snow.entity.FallingSnowEntity;

public class ModSnowBlock
extends SnowBlock
implements SnowVariant {
    public static final VoxelShape[] SNOW_SHAPES_MAGIC = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0)};

    public ModSnowBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (ModUtil.terraforged || !SnowCommonConfig.thinnerBoundingBox) {
            return super.func_220071_b(state, worldIn, pos, context);
        }
        int layers = (Integer)state.func_177229_b((Property)field_176315_a);
        if (layers == 8) {
            return VoxelShapes.func_197868_b();
        }
        return SNOW_SHAPES_MAGIC[layers - 1];
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate());
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, this.tickRate());
            return stateIn;
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.isValidPosition(state, (IBlockReader)worldIn, pos, false);
    }

    public boolean isValidPosition(BlockState state, IBlockReader worldIn, BlockPos pos, boolean ignoreSelf) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block instanceof SnowBlock && (Integer)blockstate.func_177229_b((Property)field_176315_a) == 8) {
            return true;
        }
        return !((!SnowCommonConfig.snowOnIce || block != Blocks.field_150432_aD && block != Blocks.field_150403_cj) && block.func_203417_a(CoreModule.INVALID_SUPPORTERS) || !ignoreSelf && !state.func_185904_a().func_76222_j() && !ModSnowBlock.canContainState(state) || !block.func_203417_a((ITag)BlockTags.field_206952_E) && !Block.func_208061_a((VoxelShape)blockstate.func_196952_d(worldIn, pos.func_177977_b()), (Direction)Direction.UP));
    }

    protected int tickRate() {
        return 2;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        this.checkFallable((World)worldIn, pos, state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (ModUtil.shouldMelt((World)worldIn, pos)) {
            BlockState upState;
            int layers = (Integer)state.func_177229_b((Property)field_176315_a);
            if (layers == 8 && (upState = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof SnowBlock) {
                return;
            }
            if (state.func_177230_c() == CoreModule.TILE_BLOCK) {
                state.removedByPlayer((World)worldIn, pos, null, false, null);
            } else {
                ModSnowBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
            return;
        }
        if (ModUtil.terraforged) {
            return;
        }
        if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
            return;
        }
        if (random.nextInt(8) > 0) {
            return;
        }
        BlockPos height = worldIn.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        if (height.func_177956_o() != pos.func_177956_o()) {
            return;
        }
        Biome biome = worldIn.func_226691_t_(pos);
        boolean flag = false;
        if (worldIn.func_72896_J() && ModUtil.isColdAt((World)worldIn, biome, pos)) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.func_72911_I()) {
                flag = true;
            }
        }
        int layers = (Integer)state.func_177229_b((Property)field_176315_a);
        if (flag && layers < SnowCommonConfig.snowAccumulationMaxLayers) {
            ModSnowBlock.accumulate((World)worldIn, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.func_180495_p(p.func_177977_b()).func_177230_c() instanceof ModSnowBlock)) && w.func_226658_a_(LightType.BLOCK, p) < 10, true);
        } else if (!SnowCommonConfig.snowNeverMelt && SnowCommonConfig.snowNaturalMelt && !worldIn.func_72896_J()) {
            if (layers == 1) {
                if (SnowCommonConfig.snowAccumulationMaxLayers > 8 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof ModSnowBlock) {
                    worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
            } else {
                ModSnowBlock.accumulate((World)worldIn, pos, state, (w, p) -> !(w.func_180495_p(p.func_177984_a()).func_177230_c() instanceof ModSnowBlock), false);
            }
        }
    }

    private static void accumulate(World world, BlockPos pos, BlockState centerState, BiPredicate<IWorld, BlockPos> filter, boolean accumulate) {
        int i = (Integer)centerState.func_177229_b((Property)field_176315_a);
        for (int j = 0; j < 8; ++j) {
            int k = j / 2;
            Direction direction = Direction.func_176731_b((int)k);
            BlockPos pos2 = pos.func_177972_a(direction);
            if (j % 2 == 1) {
                pos2 = pos2.func_177972_a(Direction.func_176731_b((int)(k + 1)));
            }
            if (!world.func_195588_v(pos2) || !filter.test((IWorld)world, pos2)) continue;
            BlockState state = world.func_180495_p(pos2);
            BlockPos height = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos2);
            if (height.func_177956_o() != pos2.func_177956_o() || !CoreModule.BLOCK.func_196260_a(state, (IWorldReader)world, pos2)) continue;
            int l = state.func_177230_c() instanceof SnowBlock ? (Integer)state.func_177229_b((Property)field_176315_a) : 0;
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                ModSnowBlock.placeLayersOn(world, pos2, 1, false, (BlockItemUseContext)new DirectionalPlaceContext(world, pos2, Direction.UP, ItemStack.field_190927_a, Direction.DOWN), false);
            } else {
                world.func_175656_a(pos2, (BlockState)state.func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            ModSnowBlock.placeLayersOn(world, pos, 1, false, (BlockItemUseContext)new DirectionalPlaceContext(world, pos, Direction.UP, ItemStack.field_190927_a, Direction.DOWN), false);
        } else {
            world.func_175656_a(pos, (BlockState)centerState.func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(i - 1)));
        }
    }

    protected boolean checkFallable(World worldIn, BlockPos pos, BlockState state) {
        BlockPos posDown = pos.func_177977_b();
        if (ModSnowBlock.canFallThrough(worldIn.func_180495_p(posDown), worldIn, posDown) && pos.func_177956_o() >= 0) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, this.getRaw(state, (IBlockReader)worldIn, pos));
                FallingSnowEntity entity = new FallingSnowEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, (Integer)state.func_177229_b((Property)field_176315_a));
                worldIn.func_217376_c((Entity)entity);
            }
            return true;
        }
        return false;
    }

    public static boolean placeLayersOn(World world, BlockPos pos, int layers, boolean fallingEffect, BlockItemUseContext useContext, boolean playSound) {
        layers = MathHelper.func_76125_a((int)layers, (int)1, (int)8);
        BlockState state = world.func_180495_p(pos);
        int originLayers = 0;
        if (state.func_177230_c() instanceof SnowBlock) {
            originLayers = (Integer)state.func_177229_b((Property)field_176315_a);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers), (int)1, (int)8))));
        } else if (ModSnowBlock.canContainState(state) && state.func_196955_c((IWorldReader)world, pos)) {
            ModSnowBlock.convert((IWorld)world, pos, state, MathHelper.func_76125_a((int)layers, (int)1, (int)8), 3);
        } else if (CoreModule.BLOCK.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175656_a(pos, (BlockState)CoreModule.BLOCK.func_176223_P().func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)layers, (int)1, (int)8))));
        } else {
            return false;
        }
        if (fallingEffect) {
            world.func_175641_c(pos, (Block)CoreModule.BLOCK, originLayers, layers);
        } else if (playSound) {
            SoundType soundtype = CoreModule.BLOCK.func_220072_p(CoreModule.BLOCK.func_176223_P());
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.func_177984_a();
            if (CoreModule.BLOCK.func_196260_a(CoreModule.BLOCK.func_176223_P(), (IWorldReader)world, pos) && world.func_180495_p(pos).func_196953_a(useContext)) {
                ModSnowBlock.placeLayersOn(world, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound);
            }
        }
        return true;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((Property)field_176315_a);
        if (useContext.func_195996_i().func_77973_b() == CoreModule.BLOCK.func_199767_j() && i < 8) {
            if (useContext.func_196012_c() && state.func_177230_c() == CoreModule.BLOCK) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return SnowCommonConfig.snowAlwaysReplaceable && (Integer)state.func_177229_b((Property)field_176315_a) < 8 || i == 1;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int originLayers, int layers) {
        double offsetY = (double)originLayers / 8.0;
        layers *= 10;
        for (int i = 0; i < layers; ++i) {
            double d0 = this.RANDOM.nextGaussian() * 0.1;
            double d1 = this.RANDOM.nextGaussian() * 0.02;
            double d2 = this.RANDOM.nextGaussian() * 0.1;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, (double)((float)pos.func_177958_n() + this.RANDOM.nextFloat()), (double)pos.func_177956_o() + offsetY, (double)((float)pos.func_177952_p() + this.RANDOM.nextFloat()), d0, d1, d2);
        }
        SoundType soundtype = this.getSoundType(state, (IWorldReader)worldIn, pos, null);
        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!SnowClientConfig.particleThroughLeaves || rand.nextInt(32) > 0) {
            return;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null && entity.func_233580_cy_().func_177951_i((Vector3i)pos) > 256.0) {
            return;
        }
        BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, stateIn), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state) {
        return -1;
    }

    public static boolean canFallThrough(BlockState state, World worldIn, BlockPos pos) {
        if (state.func_196952_d((IBlockReader)worldIn, pos).func_197766_b() && (FallingBlock.func_185759_i((BlockState)state) || ModSnowBlock.canContainState(state))) {
            return true;
        }
        return state.func_177230_c() instanceof SnowBlock && (Integer)state.func_177229_b((Property)field_176315_a) < 8;
    }

    @Override
    public BlockState onShovel(BlockState state, World world, BlockPos pos) {
        int layers = (Integer)state.func_177229_b((Property)field_176315_a) - 1;
        if (layers > 0) {
            return (BlockState)state.func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(layers));
        }
        return this.getRaw(state, (IBlockReader)world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState state2;
        BlockItemUseContext context;
        Block block;
        BlockState stateDown;
        if (player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b() && !((stateDown = worldIn.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof SnowBlock) && !stateDown.func_235901_b_((Property)BlockStateProperties.field_208196_w)) {
            TileEntity blockEntity;
            if (state.func_177230_c() == CoreModule.BLOCK) {
                worldIn.func_180501_a(pos, ModSnowBlock.copyProperties(state, CoreModule.TILE_BLOCK.func_176223_P()), 48);
            }
            if ((blockEntity = worldIn.func_175625_s(pos)) instanceof SnowTile) {
                SnowTile snowTile = (SnowTile)blockEntity;
                if (state.func_177230_c() == CoreModule.TILE_BLOCK && snowTile.getState().func_196958_f()) {
                    worldIn.func_180501_a(pos, ModSnowBlock.copyProperties(state, CoreModule.BLOCK.func_176223_P()), 48);
                } else {
                    boolean bl = snowTile.options.renderOverlay = !snowTile.options.renderOverlay;
                    if (worldIn.field_72995_K) {
                        worldIn.markAndNotifyBlock(pos, worldIn.func_175726_f(pos), state, state, 11, 512);
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (state.func_177230_c() == CoreModule.BLOCK && (block = Block.func_149634_a((Item)(context = new BlockItemUseContext(new ItemUseContext(player, handIn, hit))).func_195996_i().func_77973_b())) != null && block != Blocks.field_150350_a && context.func_196012_c() && (state2 = block.func_196258_a(context)) != null && ModSnowBlock.canContainState(state2) && state2.func_196955_c((IWorldReader)worldIn, pos)) {
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, state2, 48);
                block.func_180633_a(worldIn, pos, state, (LivingEntity)player, context.func_195996_i());
                int i = (Integer)state.func_177229_b((Property)field_176315_a);
                if (ModSnowBlock.placeLayersOn(worldIn, pos, i, false, context, true) && !player.func_184812_l_()) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() instanceof SnowBlock) {
            int i = (Integer)blockstate.func_177229_b((Property)field_176315_a);
            return (BlockState)blockstate.func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    public static boolean canContainState(BlockState state) {
        if (!SnowCommonConfig.placeSnowInBlock || state.func_177230_c().hasTileEntity(state) || !state.func_204520_s().func_206888_e()) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block.func_203417_a(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (block.func_203417_a(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            return true;
        }
        if (block instanceof FenceBlock && block.func_203417_a((ITag)BlockTags.field_219748_G)) {
            return ModSnowBlock.hasAllProperties(state, CoreModule.FENCE.func_176223_P());
        }
        if (block instanceof FenceGateBlock && block.func_203417_a((ITag)BlockTags.field_232868_aA_)) {
            return ModSnowBlock.hasAllProperties(state, CoreModule.FENCE_GATE.func_176223_P());
        }
        if (block instanceof WallBlock && block.func_203417_a((ITag)BlockTags.field_219757_z)) {
            return ModSnowBlock.hasAllProperties(state, CoreModule.WALL.func_176223_P());
        }
        if (block instanceof SlabBlock && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM && block.func_203417_a((ITag)BlockTags.field_203292_x)) {
            return true;
        }
        if (block instanceof StairsBlock && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM && block.func_203417_a((ITag)BlockTags.field_203291_w)) {
            return ModSnowBlock.hasAllProperties(state, CoreModule.STAIRS.func_176223_P());
        }
        return false;
    }

    public static boolean convert(IWorld world, BlockPos pos, BlockState state, int layers, int flags) {
        BlockState newState;
        if (!SnowCommonConfig.placeSnowInBlock || state.hasTileEntity()) {
            return false;
        }
        Block block = state.func_177230_c();
        if (state.func_196958_f()) {
            world.func_180501_a(pos, (BlockState)CoreModule.BLOCK.func_176223_P().func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(layers)), flags);
            return true;
        }
        if (block.func_203417_a(CoreModule.CONTAINABLES) || block instanceof TallGrassBlock || block instanceof DoublePlantBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            world.func_180501_a(pos, (BlockState)CoreModule.TILE_BLOCK.func_176223_P().func_206870_a((Property)field_176315_a, (Comparable)Integer.valueOf(layers)), flags);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof SnowTile) {
                ((SnowTile)tile).setState(state);
            }
            return true;
        }
        BlockPos posDown = pos.func_177977_b();
        BlockState stateDown = world.func_180495_p(posDown);
        if (block instanceof StairsBlock && block != CoreModule.STAIRS && block.func_203417_a((ITag)BlockTags.field_203291_w)) {
            newState = CoreModule.STAIRS.func_176223_P();
            newState = ModSnowBlock.copyProperties(state, newState);
            world.func_180501_a(pos, newState, flags);
        } else if (block instanceof SlabBlock && block != CoreModule.SLAB && state.func_177229_b((Property)SlabBlock.field_196505_a) == SlabType.BOTTOM && block.func_203417_a((ITag)BlockTags.field_203292_x)) {
            world.func_180501_a(pos, CoreModule.SLAB.func_176223_P(), flags);
        } else if (block instanceof FenceBlock && block.getClass() != SnowFenceBlock.class && block.func_203417_a((ITag)BlockTags.field_219748_G)) {
            SnowFenceBlock newBlock = block.func_203417_a((ITag)BlockTags.field_219756_j) ? CoreModule.FENCE : CoreModule.FENCE2;
            BlockState newState2 = newBlock.func_176223_P();
            newState2 = ModSnowBlock.copyProperties(state, newState2);
            newState2 = newState2.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState2, flags);
        } else if (block instanceof FenceGateBlock && block != CoreModule.FENCE_GATE && block.func_203417_a((ITag)BlockTags.field_232868_aA_)) {
            newState = CoreModule.FENCE_GATE.func_176223_P();
            newState = ModSnowBlock.copyProperties(state, newState);
            newState = newState.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState, flags);
        } else if (block instanceof WallBlock && block != CoreModule.WALL && block.func_203417_a((ITag)BlockTags.field_219757_z)) {
            newState = CoreModule.WALL.func_176223_P();
            newState = ModSnowBlock.copyProperties(state, newState);
            newState = newState.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState, flags);
        } else {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof SnowTile) {
            ((SnowTile)tile).setState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.func_206871_b().entrySet()) {
            Property property = (Property)entry.getKey();
            if (newState.func_235901_b_(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> BlockState copyProperties(BlockState oldState, BlockState newState) {
        for (Map.Entry entry : oldState.func_206871_b().entrySet()) {
            Property property = (Property)entry.getKey();
            if (!newState.func_235901_b_(property)) continue;
            newState = (BlockState)newState.func_206870_a(property, (Comparable)property.func_177699_b().cast(entry.getValue()));
        }
        return newState;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (SnowCommonConfig.snowReduceFallDamage) {
            BlockState state = worldIn.func_180495_p(pos.func_177977_b());
            if (!state.func_203425_a((Block)this)) {
                return;
            }
            if (state.func_177230_c() == CoreModule.BLOCK || state.func_177230_c() == CoreModule.TILE_BLOCK) {
                entityIn.func_225503_b_(fallDistance, 0.2f);
                return;
            }
            state = worldIn.func_180495_p(pos);
            entityIn.func_225503_b_(fallDistance, 1.0f - (float)((Integer)state.func_177229_b((Property)field_176315_a)).intValue() * 0.1f);
            return;
        }
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        double d0;
        if (SnowCommonConfig.thinnerBoundingBox && (d0 = Math.abs(entityIn.func_213322_ci().field_72448_b)) < 0.1 && !entityIn.func_226271_bk_()) {
            BlockState state = worldIn.func_180495_p(pos);
            if (!state.func_203425_a((Block)this)) {
                return;
            }
            int layers = (Integer)state.func_177229_b((Property)field_176315_a) - 1;
            double d1 = 1.0f - (float)layers * 0.05f;
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(d1, 1.0, d1));
        }
    }

    @Override
    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return super.getPickBlock(state, target, world, pos, player);
    }
}

