/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowBlock;
import net.minecraft.entity.Entity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import snownee.snow.CoreModule;
import snownee.snow.ModUtil;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;
import snownee.snow.block.ModSnowBlock;
import snownee.snow.entity.FallingSnowEntity;

public class WorldTickHandler {
    private static Method METHOD;

    public static void tick(TickEvent.WorldTickEvent event) {
        Iterable holders;
        int blizzard;
        if (SnowCommonConfig.retainOriginalBlocks || METHOD == null) {
            return;
        }
        ServerWorld world = (ServerWorld)event.world;
        int n = blizzard = SnowCommonConfig.snowGravity ? world.func_82736_K().func_223592_c(CoreModule.BLIZZARD_STRENGTH) : 0;
        if (blizzard <= 0 && !world.func_72896_J()) {
            return;
        }
        if (world.func_72863_F().func_201711_g() instanceof DebugChunkGenerator) {
            return;
        }
        try {
            holders = (Iterable)METHOD.invoke((Object)world.func_72863_F().field_217237_a, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            SnowRealMagic.LOGGER.catching((Throwable)e);
            METHOD = null;
            return;
        }
        holders.forEach(holder -> {
            Chunk chunk = holder.func_219298_c();
            if (chunk == null || !world.func_72863_F().func_222865_a(chunk.func_76632_l())) {
                return;
            }
            if (world.field_73012_v.nextInt(16) == 0) {
                int y;
                int x = chunk.func_76632_l().func_180334_c();
                BlockPos.Mutable pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(x, 0, y = chunk.func_76632_l().func_180333_d(), 15)).func_239590_i_();
                if (!world.isAreaLoaded((BlockPos)pos, 1)) {
                    return;
                }
                if (blizzard > 0) {
                    WorldTickHandler.doBlizzard(world, (BlockPos)pos, blizzard);
                    return;
                }
                pos.func_189536_c(Direction.DOWN);
                Biome biome = world.func_226691_t_((BlockPos)pos);
                if (!ModUtil.isColdAt((World)world, biome, (BlockPos)pos)) {
                    return;
                }
                BlockState state = world.func_180495_p((BlockPos)pos);
                if (!ModSnowBlock.canContainState(state) && !ModSnowBlock.canContainState(state = world.func_180495_p((BlockPos)pos.func_189536_c(Direction.UP)))) {
                    return;
                }
                if (world.func_226658_a_(LightType.BLOCK, (BlockPos)pos.func_189536_c(Direction.UP)) > 11) {
                    return;
                }
                ModSnowBlock.convert((IWorld)world, (BlockPos)pos.func_189536_c(Direction.DOWN), state, 1, 3);
                for (int i = 0; i < 5 && !state.func_235714_a_((ITag)BlockTags.field_203292_x) && !state.func_235714_a_((ITag)BlockTags.field_203291_w) && ((state = world.func_180495_p((BlockPos)pos.func_189536_c(Direction.DOWN))).func_196958_f() || ModSnowBlock.canContainState(state)); ++i) {
                    if (!CoreModule.BLOCK.func_196260_a(state, (IWorldReader)world, (BlockPos)pos)) continue;
                    pos.func_189536_c(Direction.UP);
                    if (world.func_180495_p((BlockPos)pos).func_177230_c() instanceof SnowBlock || world.func_226658_a_(LightType.BLOCK, (BlockPos)pos) > 11) break;
                    ModSnowBlock.convert((IWorld)world, (BlockPos)pos.func_189536_c(Direction.DOWN), state, 1, 3);
                }
            }
        });
    }

    private static void doBlizzard(ServerWorld world, BlockPos pos, int blizzard) {
        if (pos.func_177956_o() == world.func_217301_I()) {
            return;
        }
        int frequency = world.func_82736_K().func_223592_c(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = MathHelper.func_76125_a((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.field_73012_v.nextInt(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = MathHelper.func_76125_a((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.field_73012_v.nextInt(blizzard) + 1;
        }
        pos = pos.func_177981_b(64);
        FallingSnowEntity entity = new FallingSnowEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, blizzard);
        world.func_217376_c((Entity)entity);
    }

    static {
        try {
            METHOD = ObfuscationReflectionHelper.findMethod(ChunkManager.class, (String)"func_223491_f", (Class[])new Class[0]);
        }
        catch (Exception e) {
            SnowRealMagic.LOGGER.catching((Throwable)e);
        }
    }
}

