/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.ModList;
import snownee.snow.SnowCommonConfig;
import snownee.snow.SnowRealMagic;

public class ModUtil {
    private static Method getBiomeTemperature;
    private static Method enablesSeasonalEffects;
    public static boolean terraforged;

    public static boolean shouldMelt(World world, BlockPos pos) {
        if (SnowCommonConfig.snowNeverMelt) {
            return false;
        }
        if (world.func_226658_a_(LightType.BLOCK, pos) > 11) {
            return true;
        }
        Biome biome = world.func_226691_t_(pos);
        return ModUtil.snowMeltsInWarmBiomes(biome) && !ModUtil.isColdAt(world, biome, pos) && world.func_226660_f_(pos);
    }

    public static boolean isColdAt(World world, Biome biome, BlockPos pos) {
        if (getBiomeTemperature != null) {
            try {
                return ((Float)getBiomeTemperature.invoke(null, world, biome, pos)).floatValue() < 0.15f;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                SnowRealMagic.LOGGER.catching((Throwable)e);
                getBiomeTemperature = null;
            }
        }
        return biome.func_225486_c(pos) < 0.15f;
    }

    public static boolean snowMeltsInWarmBiomes(Biome biome) {
        if (enablesSeasonalEffects != null) {
            RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.getRegistryName());
            try {
                return (Boolean)enablesSeasonalEffects.invoke(null, biomeKey);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                SnowRealMagic.LOGGER.catching((Throwable)e);
                enablesSeasonalEffects = null;
            }
        }
        return SnowCommonConfig.snowMeltsInWarmBiomes;
    }

    static {
        terraforged = false;
        if (ModList.get().isLoaded("sereneseasons")) {
            try {
                Class<?> seasonHooks = Class.forName("sereneseasons.season.SeasonHooks");
                Class<?> biomeConfig = Class.forName("sereneseasons.config.BiomeConfig");
                getBiomeTemperature = seasonHooks.getDeclaredMethod("getBiomeTemperature", World.class, Biome.class, BlockPos.class);
                enablesSeasonalEffects = biomeConfig.getDeclaredMethod("enablesSeasonalEffects", RegistryKey.class);
                SnowRealMagic.LOGGER.info("Serene Seasons compatibility enabled");
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                SnowRealMagic.LOGGER.catching((Throwable)e);
            }
        }
    }
}

