/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.WorldTickHandler;
import snownee.snow.block.SnowVariant;

@Mod.EventBusSubscriber
public final class GameEvents {
    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        World worldIn = event.getWorld();
        BlockState state = worldIn.func_180495_p(pos = event.getPos());
        if (!(state.func_177230_c() instanceof SnowVariant)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!ForgeHooks.canHarvestBlock((BlockState)CoreModule.BLOCK.func_176223_P(), (PlayerEntity)player, (IBlockReader)worldIn, (BlockPos)pos)) {
            if (!player.func_226563_dT_() || !SnowCommonConfig.sneakSnowball) {
                return;
            }
            BlockState newState = ((SnowVariant)state.func_177230_c()).onShovel(state, worldIn, pos);
            worldIn.func_175656_a(pos, newState);
            ItemStack snowball = new ItemStack((IItemProvider)Items.field_151126_ay);
            if (!player.func_184812_l_() || !player.field_71071_by.func_70431_c(snowball)) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)snowball);
            }
        } else {
            BlockState newState = ((SnowVariant)state.func_177230_c()).onShovel(state, worldIn, pos);
            worldIn.func_175656_a(pos, newState);
            if (!player.func_184812_l_() && player instanceof ServerPlayerEntity) {
                if (newState.func_200132_m()) {
                    pos = pos.func_177984_a();
                }
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151126_ay));
                player.func_184614_ca().func_222118_a(1, (LivingEntity)player, stack -> stack.func_213334_d(Hand.MAIN_HAND));
            }
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
    }

    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (SnowCommonConfig.placeSnowInBlock && event.side.isServer() && event.phase == TickEvent.Phase.END && event.world instanceof ServerWorld) {
            WorldTickHandler.tick(event);
        }
    }
}

