/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Rectangle;
import mcp.mobius.waila.api.RenderContext;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.config.PluginConfig;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import snownee.jade.JadePlugin;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class ClientHandler {
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    @SubscribeEvent
    public static void post(WailaRenderEvent.Post event) {
        if (!PluginConfig.INSTANCE.get(JadePlugin.BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        PlayerController playerController = mc.field_71442_b;
        if (playerController == null || !mc.field_71441_e.func_195588_v(playerController.field_178895_c)) {
            return;
        }
        BlockState state = mc.field_71441_e.func_180495_p(playerController.field_178895_c);
        if (playerController.func_181040_m()) {
            canHarvest = ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)mc.field_71439_g, (IBlockReader)mc.field_71441_e, (BlockPos)playerController.field_178895_c);
        }
        int color = canHarvest ? 0xFFFFFF : 0xFF4444;
        Rectangle rect = event.getPosition();
        progressAlpha += mc.func_193989_ak() * (playerController.func_181040_m() ? 0.1f : -0.1f);
        if (playerController.func_181040_m()) {
            progressAlpha = Math.min(progressAlpha, 0.53f);
            float progress = state.func_185903_a((PlayerEntity)mc.field_71439_g, (IBlockReader)mc.field_71439_g.field_70170_p, playerController.field_178895_c);
            progress = playerController.field_78770_f + mc.func_184121_ak() * progress;
            savedProgress = progress = MathHelper.func_76131_a((float)progress, (float)0.0f, (float)1.0f);
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        color = ClientHandler.applyAlpha(color, progressAlpha);
        AbstractGui.func_238467_a_((MatrixStack)RenderContext.matrixStack, (int)(rect.x + 1), (int)(rect.y + rect.height), (int)(rect.x + 1 + (int)((float)rect.width * savedProgress)), (int)(rect.y + rect.height + 1), (int)color);
    }

    private static int applyAlpha(int color, float alpha) {
        int prevAlphaChannel = color >> 24 & 0xFF;
        if (prevAlphaChannel > 0) {
            alpha *= (float)prevAlphaChannel / 256.0f;
        }
        int alphaChannel = (int)(255.0f * MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f));
        return color & 0xFFFFFF | alphaChannel << 24;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void breakBlock(BlockEvent.BreakEvent event) {
        progressAlpha = 1.0f;
    }
}

